/*
 * Decompiled with CFR 0.152.
 */
package androidx.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.ViewCompat;
import androidx.preference.ExpandButton;
import androidx.preference.Preference;
import androidx.preference.PreferenceGroup;
import androidx.preference.PreferenceManager;
import androidx.preference.PreferenceScreen;
import androidx.preference.PreferenceViewHolder;
import androidx.preference.R;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class PreferenceGroupAdapter
extends RecyclerView.Adapter<PreferenceViewHolder>
implements Preference.OnPreferenceChangeInternalListener,
PreferenceGroup.PreferencePositionCallback {
    private PreferenceGroup mPreferenceGroup;
    private List<Preference> mPreferences;
    private List<Preference> mVisiblePreferences;
    private List<PreferenceResourceDescriptor> mPreferenceResourceDescriptors;
    private Handler mHandler;
    private Runnable mSyncRunnable = new Runnable(){

        @Override
        public void run() {
            PreferenceGroupAdapter.this.updatePreferences();
        }
    };

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        this.mPreferenceGroup = preferenceGroup;
        this.mHandler = new Handler();
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        this.mPreferences = new ArrayList<Preference>();
        this.mVisiblePreferences = new ArrayList<Preference>();
        this.mPreferenceResourceDescriptors = new ArrayList<PreferenceResourceDescriptor>();
        if (this.mPreferenceGroup instanceof PreferenceScreen) {
            this.setHasStableIds(((PreferenceScreen)this.mPreferenceGroup).shouldUseGeneratedIds());
        } else {
            this.setHasStableIds(true);
        }
        this.updatePreferences();
    }

    void updatePreferences() {
        for (Preference preference : this.mPreferences) {
            preference.setOnPreferenceChangeInternalListener(null);
        }
        int size = this.mPreferences.size();
        this.mPreferences = new ArrayList<Preference>(size);
        this.flattenPreferenceGroup(this.mPreferences, this.mPreferenceGroup);
        final List<Preference> oldVisibleList = this.mVisiblePreferences;
        final List<Preference> visiblePreferenceList = this.createVisiblePreferencesList(this.mPreferenceGroup);
        this.mVisiblePreferences = visiblePreferenceList;
        PreferenceManager preferenceManager = this.mPreferenceGroup.getPreferenceManager();
        if (preferenceManager != null && preferenceManager.getPreferenceComparisonCallback() != null) {
            final PreferenceManager.PreferenceComparisonCallback comparisonCallback = preferenceManager.getPreferenceComparisonCallback();
            DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

                public int getOldListSize() {
                    return oldVisibleList.size();
                }

                public int getNewListSize() {
                    return visiblePreferenceList.size();
                }

                public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                    return comparisonCallback.arePreferenceItemsTheSame((Preference)oldVisibleList.get(oldItemPosition), (Preference)visiblePreferenceList.get(newItemPosition));
                }

                public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                    return comparisonCallback.arePreferenceContentsTheSame((Preference)oldVisibleList.get(oldItemPosition), (Preference)visiblePreferenceList.get(newItemPosition));
                }
            });
            result.dispatchUpdatesTo((RecyclerView.Adapter)this);
        } else {
            this.notifyDataSetChanged();
        }
        for (Preference preference : this.mPreferences) {
            preference.clearWasDetached();
        }
    }

    private void flattenPreferenceGroup(List<Preference> preferences, PreferenceGroup group) {
        group.sortPreferences();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            PreferenceGroup nestedGroup;
            Preference preference = group.getPreference(i);
            preferences.add(preference);
            PreferenceResourceDescriptor descriptor = new PreferenceResourceDescriptor(preference);
            if (!this.mPreferenceResourceDescriptors.contains(descriptor)) {
                this.mPreferenceResourceDescriptors.add(descriptor);
            }
            if (preference instanceof PreferenceGroup && (nestedGroup = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(preferences, nestedGroup);
            }
            preference.setOnPreferenceChangeInternalListener(this);
        }
    }

    private List<Preference> createVisiblePreferencesList(PreferenceGroup group) {
        int visiblePreferenceCount = 0;
        ArrayList<Preference> visiblePreferences = new ArrayList<Preference>();
        ArrayList<Preference> collapsedPreferences = new ArrayList<Preference>();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            Preference preference = group.getPreference(i);
            if (!preference.isVisible()) continue;
            if (!this.isGroupExpandable(group) || visiblePreferenceCount < group.getInitialExpandedChildrenCount()) {
                visiblePreferences.add(preference);
            } else {
                collapsedPreferences.add(preference);
            }
            if (!(preference instanceof PreferenceGroup)) {
                ++visiblePreferenceCount;
                continue;
            }
            PreferenceGroup innerGroup = (PreferenceGroup)preference;
            if (!innerGroup.isOnSameScreenAsChildren()) continue;
            if (this.isGroupExpandable(group) && this.isGroupExpandable(innerGroup)) {
                throw new IllegalStateException("Nesting an expandable group inside of another expandable group is not supported!");
            }
            List<Preference> innerList = this.createVisiblePreferencesList(innerGroup);
            for (Preference inner : innerList) {
                if (!this.isGroupExpandable(group) || visiblePreferenceCount < group.getInitialExpandedChildrenCount()) {
                    visiblePreferences.add(inner);
                } else {
                    collapsedPreferences.add(inner);
                }
                ++visiblePreferenceCount;
            }
        }
        if (this.isGroupExpandable(group) && visiblePreferenceCount > group.getInitialExpandedChildrenCount()) {
            ExpandButton expandButton = this.createExpandButton(group, collapsedPreferences);
            visiblePreferences.add(expandButton);
        }
        return visiblePreferences;
    }

    private ExpandButton createExpandButton(final PreferenceGroup group, List<Preference> collapsedPreferences) {
        ExpandButton preference = new ExpandButton(group.getContext(), collapsedPreferences, group.getId());
        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            @Override
            public boolean onPreferenceClick(Preference preference) {
                group.setInitialExpandedChildrenCount(Integer.MAX_VALUE);
                PreferenceGroupAdapter.this.onPreferenceHierarchyChange(preference);
                PreferenceGroup.OnExpandButtonClickListener listener = group.getOnExpandButtonClickListener();
                if (listener != null) {
                    listener.onExpandButtonClick();
                }
                return true;
            }
        });
        return preference;
    }

    private boolean isGroupExpandable(PreferenceGroup preferenceGroup) {
        return preferenceGroup.getInitialExpandedChildrenCount() != Integer.MAX_VALUE;
    }

    public Preference getItem(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return null;
        }
        return this.mVisiblePreferences.get(position);
    }

    public int getItemCount() {
        return this.mVisiblePreferences.size();
    }

    public long getItemId(int position) {
        if (!this.hasStableIds()) {
            return -1L;
        }
        return this.getItem(position).getId();
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        int index = this.mVisiblePreferences.indexOf(preference);
        if (index != -1) {
            this.notifyItemChanged(index, preference);
        }
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        this.mHandler.removeCallbacks(this.mSyncRunnable);
        this.mHandler.post(this.mSyncRunnable);
    }

    @Override
    public void onPreferenceVisibilityChange(Preference preference) {
        this.onPreferenceHierarchyChange(preference);
    }

    public int getItemViewType(int position) {
        Preference preference = this.getItem(position);
        PreferenceResourceDescriptor descriptor = new PreferenceResourceDescriptor(preference);
        int viewType = this.mPreferenceResourceDescriptors.indexOf(descriptor);
        if (viewType != -1) {
            return viewType;
        }
        viewType = this.mPreferenceResourceDescriptors.size();
        this.mPreferenceResourceDescriptors.add(descriptor);
        return viewType;
    }

    @NonNull
    public PreferenceViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ViewGroup widgetFrame;
        PreferenceResourceDescriptor descriptor = this.mPreferenceResourceDescriptors.get(viewType);
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        TypedArray a = parent.getContext().obtainStyledAttributes(null, R.styleable.BackgroundStyle);
        Drawable background = a.getDrawable(R.styleable.BackgroundStyle_android_selectableItemBackground);
        if (background == null) {
            background = AppCompatResources.getDrawable((Context)parent.getContext(), (int)17301602);
        }
        a.recycle();
        View view = inflater.inflate(descriptor.mLayoutResId, parent, false);
        if (view.getBackground() == null) {
            ViewCompat.setBackground((View)view, (Drawable)background);
        }
        if ((widgetFrame = (ViewGroup)view.findViewById(16908312)) != null) {
            if (descriptor.mWidgetLayoutResId != 0) {
                inflater.inflate(descriptor.mWidgetLayoutResId, widgetFrame);
            } else {
                widgetFrame.setVisibility(8);
            }
        }
        return new PreferenceViewHolder(view);
    }

    public void onBindViewHolder(@NonNull PreferenceViewHolder holder, int position) {
        Preference preference = this.getItem(position);
        preference.onBindViewHolder(holder);
    }

    @Override
    public int getPreferenceAdapterPosition(String key) {
        int size = this.mVisiblePreferences.size();
        for (int i = 0; i < size; ++i) {
            Preference candidate = this.mVisiblePreferences.get(i);
            if (!TextUtils.equals((CharSequence)key, (CharSequence)candidate.getKey())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getPreferenceAdapterPosition(Preference preference) {
        int size = this.mVisiblePreferences.size();
        for (int i = 0; i < size; ++i) {
            Preference candidate = this.mVisiblePreferences.get(i);
            if (candidate == null || !candidate.equals(preference)) continue;
            return i;
        }
        return -1;
    }

    private static class PreferenceResourceDescriptor {
        int mLayoutResId;
        int mWidgetLayoutResId;
        String mClassName;

        PreferenceResourceDescriptor(Preference preference) {
            this.mClassName = preference.getClass().getName();
            this.mLayoutResId = preference.getLayoutResource();
            this.mWidgetLayoutResId = preference.getWidgetLayoutResource();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PreferenceResourceDescriptor)) {
                return false;
            }
            PreferenceResourceDescriptor other = (PreferenceResourceDescriptor)o;
            return this.mLayoutResId == other.mLayoutResId && this.mWidgetLayoutResId == other.mWidgetLayoutResId && TextUtils.equals((CharSequence)this.mClassName, (CharSequence)other.mClassName);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.mLayoutResId;
            result = 31 * result + this.mWidgetLayoutResId;
            result = 31 * result + this.mClassName.hashCode();
            return result;
        }
    }
}

