/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilerPhases;
import org.jetbrains.kotlin.backend.common.DefaultIrPhaseRunner;
import org.jetbrains.kotlin.backend.jvm.IrFileEndPhase;
import org.jetbrains.kotlin.backend.jvm.IrFileStartPhase;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmPhaseRunner;", "Lorg/jetbrains/kotlin/backend/common/DefaultIrPhaseRunner;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "()V", "endPhaseMarker", "Lorg/jetbrains/kotlin/backend/jvm/IrFileEndPhase;", "getEndPhaseMarker", "()Lorg/jetbrains/kotlin/backend/jvm/IrFileEndPhase;", "startPhaseMarker", "Lorg/jetbrains/kotlin/backend/jvm/IrFileStartPhase;", "getStartPhaseMarker", "()Lorg/jetbrains/kotlin/backend/jvm/IrFileStartPhase;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "context", "elementName", "", "input", "phases", "Lorg/jetbrains/kotlin/backend/common/CompilerPhases;", "backend"})
public final class JvmPhaseRunner
extends DefaultIrPhaseRunner<JvmBackendContext, IrFile> {
    @NotNull
    private static final IrFileStartPhase startPhaseMarker;
    @NotNull
    private static final IrFileEndPhase endPhaseMarker;
    public static final JvmPhaseRunner INSTANCE;

    @NotNull
    public IrFileStartPhase getStartPhaseMarker() {
        return startPhaseMarker;
    }

    @NotNull
    public IrFileEndPhase getEndPhaseMarker() {
        return endPhaseMarker;
    }

    @Override
    @NotNull
    protected CompilerPhases phases(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return context.getPhases();
    }

    @Override
    @NotNull
    protected String elementName(@NotNull IrFile input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return IrFileKt.getName(input);
    }

    @Override
    @NotNull
    protected CompilerConfiguration configuration(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return context.getState().getConfiguration();
    }

    private JvmPhaseRunner() {
        super(null, 1, null);
    }

    static {
        JvmPhaseRunner jvmPhaseRunner;
        INSTANCE = jvmPhaseRunner = new JvmPhaseRunner();
        startPhaseMarker = IrFileStartPhase.INSTANCE;
        endPhaseMarker = IrFileEndPhase.INSTANCE;
    }
}

