/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.MultipleCandidateMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAttributeMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAttributeMatcher.class);
    private CachedQuery lastQuery;

    public boolean isMatching(AttributeSelectionSchema schema, AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return true;
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        for (Attribute attribute : requestedAttributes.keySet()) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (!candidateValue.isPresent()) continue;
            Object coercedValue = candidateValue.coerce(attribute);
            boolean match = schema.matchValue(attribute, requestedValue.get(), coercedValue);
            if (match) continue;
            return false;
        }
        return true;
    }

    public List<AttributeMatcher.MatchingDescription> describeMatching(AttributeSelectionSchema schema, AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        ImmutableSet attributes = requestedAttributes.keySet();
        ArrayList result = Lists.newArrayListWithCapacity((int)attributes.size());
        for (Attribute attribute : attributes) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (candidateValue.isPresent()) {
                Object coercedValue = candidateValue.coerce(attribute);
                boolean match = schema.matchValue(attribute, requestedValue.get(), coercedValue);
                result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, match));
                continue;
            }
            result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, false));
        }
        return result;
    }

    public <T extends HasAttributes> List<T> match(AttributeSelectionSchema schema, Collection<? extends T> candidates, AttributeContainerInternal requested, @Nullable T fallback) {
        CachedQuery lastQuery;
        if (candidates.size() == 0) {
            if (fallback != null && this.isMatching(schema, (AttributeContainerInternal)fallback.getAttributes(), requested)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No candidates for {}, selected matching fallback {}", (Object)requested, fallback);
                }
                return ImmutableList.of(fallback);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No candidates for {} and fallback {} does not match. Select nothing.", (Object)requested, fallback);
            }
            return ImmutableList.of();
        }
        if (candidates.size() == 1) {
            HasAttributes candidate = (HasAttributes)candidates.iterator().next();
            if (this.isMatching(schema, (AttributeContainerInternal)candidate.getAttributes(), requested)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Selected match {} from candidates {} for {}", new Object[]{candidate, candidates, requested});
                }
                return Collections.singletonList(candidate);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Selected match [] from candidates {} for {}", candidates, (Object)requested);
            }
            return ImmutableList.of();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        CachedQuery query = CachedQuery.of(schema, requestedAttributes, candidates);
        if (query.equals(lastQuery = this.lastQuery)) {
            return lastQuery.select(candidates);
        }
        List<? extends T> matches = new MultipleCandidateMatcher<T>(schema, candidates, requestedAttributes).getMatches();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Selected matches {} from candidates {} for {}", new Object[]{matches, candidates, requested});
        }
        this.cacheMatchingResult(candidates, query, matches);
        return matches;
    }

    private synchronized <T extends HasAttributes> void cacheMatchingResult(Collection<? extends T> candidates, CachedQuery query, List<T> matches) {
        int[] queryResult;
        if (matches.isEmpty()) {
            queryResult = new int[]{};
        } else {
            queryResult = new int[matches.size()];
            int i = 0;
            int j = 0;
            Iterator<T> resultIterator = matches.iterator();
            HasAttributes next = (HasAttributes)resultIterator.next();
            for (HasAttributes candidate : candidates) {
                if (candidate == next) {
                    queryResult[i++] = j;
                    if (!resultIterator.hasNext()) break;
                    next = (HasAttributes)resultIterator.next();
                }
                ++j;
            }
        }
        CachedQuery.access$002(query, queryResult);
        this.lastQuery = query;
    }

    private static class CachedQuery {
        private final AttributeSelectionSchema schema;
        private final ImmutableAttributes requestedAttributes;
        private final ImmutableAttributes[] candidates;
        private volatile int[] index;

        private CachedQuery(AttributeSelectionSchema schema, ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            this.schema = schema;
            this.requestedAttributes = requestedAttributes;
            this.candidates = candidates;
        }

        public static <T extends HasAttributes> CachedQuery of(AttributeSelectionSchema schema, ImmutableAttributes requestedAttributes, Collection<T> candidates) {
            ImmutableAttributes[] attributes = new ImmutableAttributes[candidates.size()];
            int i = 0;
            for (HasAttributes candidate : candidates) {
                attributes[i++] = ((AttributeContainerInternal)candidate.getAttributes()).asImmutable();
            }
            return new CachedQuery(schema, requestedAttributes, attributes);
        }

        public <T extends HasAttributes> List<T> select(Collection<? extends T> unfiltered) {
            if (this.index.length == 0) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)this.index.length);
            int i = 0;
            int j = 0;
            int k = this.index[j];
            for (HasAttributes t : unfiltered) {
                if (i == k) {
                    result.add(t);
                    if (result.size() == this.index.length) break;
                    k = this.index[++j];
                }
                ++i;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedQuery that = (CachedQuery)o;
            return this.schema.equals(that.schema) && this.requestedAttributes.equals(that.requestedAttributes) && Arrays.equals(this.candidates, that.candidates);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.schema, this.requestedAttributes, this.candidates});
        }

        static /* synthetic */ int[] access$002(CachedQuery x0, int[] x1) {
            x0.index = x1;
            return x1;
        }
    }
}

