/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.api.StdinHandler;
import org.gradle.util.StdinSwapper;

public class ForwardClientInput
implements DaemonCommandAction {
    private static final Logger LOGGER = Logging.getLogger(ForwardClientInput.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final DaemonCommandExecution execution) {
        PipedInputStream replacementStdin;
        final PipedOutputStream inputSource = new PipedOutputStream();
        try {
            replacementStdin = new PipedInputStream(inputSource);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        execution.getConnection().onStdin(new StdinHandler(){

            @Override
            public void onInput(ForwardInput input) {
                LOGGER.debug("Writing forwarded input on daemon's stdin.");
                try {
                    inputSource.write(input.getBytes());
                }
                catch (IOException e) {
                    LOGGER.warn("Received exception trying to forward client input.", (Throwable)e);
                }
            }

            @Override
            public void onEndOfInput() {
                LOGGER.info("Closing daemon's stdin at end of input.");
                try {
                    inputSource.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Problem closing output stream connected to replacement stdin", (Throwable)e);
                }
                finally {
                    LOGGER.info("The daemon will no longer process any standard input.");
                }
            }
        });
        try {
            try {
                new StdinSwapper().swap((Object)replacementStdin, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        execution.proceed();
                        return null;
                    }
                });
            }
            finally {
                execution.getConnection().onStdin(null);
                IoActions.closeQuietly((Closeable)replacementStdin);
                IoActions.closeQuietly((Closeable)inputSource);
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

