/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import gnu.trove.TDoubleObjectHashMap;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.CopyableIcon;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ScalableIcon;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.LazyInitializer;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.ui.JBEmptyBorder;
import org.jetbrains.kotlin.com.intellij.util.ui.JBFont;
import org.jetbrains.kotlin.com.intellij.util.ui.JBInsets;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new JBUI());
    public static final boolean SCALE_VERBOSE = Boolean.getBoolean("ide.ui.scale.verbose");
    private static final LazyInitializer.NotNullValue<Float> SYSTEM_SCALE_FACTOR = new LazyInitializer.NotNullValue<Float>(){

        @Override
        @NotNull
        public Float initialize() {
            if (!SystemProperties.getBooleanProperty("hidpi", true)) {
                Float f = Float.valueOf(1.0f);
                if (f == null) {
                    1.$$$reportNull$$$0(0);
                }
                return f;
            }
            if (UIUtil.isJreHiDPIEnabled()) {
                GraphicsDevice gd = null;
                try {
                    gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
                if (gd != null && gd.getDefaultConfiguration() != null) {
                    Float f = Float.valueOf(JBUI.sysScale(gd.getDefaultConfiguration()));
                    if (f == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return f;
                }
                Float f = Float.valueOf(1.0f);
                if (f == null) {
                    1.$$$reportNull$$$0(2);
                }
                return f;
            }
            UIUtil.initSystemFontData();
            Pair<String, Integer> fdata = UIUtil.getSystemFontData();
            int size = fdata == null ? Fonts.label().getSize() : fdata.getSecond().intValue();
            Float f = Float.valueOf(JBUI.getFontScale(size));
            if (f == null) {
                1.$$$reportNull$$$0(3);
            }
            return f;
        }

        @Override
        protected void onInitialized(@NotNull Float scale) {
            if (scale == null) {
                1.$$$reportNull$$$0(4);
            }
            LOG.info("System scale factor: " + scale + " (" + (UIUtil.isJreHiDPIEnabled() ? "JRE" : "IDE") + "-managed HiDPI)");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initialize";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onInitialized";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final LazyInitializer.NullableValue<Float> DEBUG_USER_SCALE_FACTOR = new LazyInitializer.NullableValue<Float>(){

        @Override
        @Nullable
        public Float initialize() {
            String prop = System.getProperty("ide.ui.scale");
            if (prop != null) {
                try {
                    return Float.valueOf(Float.parseFloat(prop));
                }
                catch (NumberFormatException e) {
                    LOG.error("ide.ui.scale system property is not a float value: " + prop);
                }
            } else if (Registry.is("ide.ui.scale.override")) {
                return Float.valueOf((float)Registry.get("ide.ui.scale").asDouble());
            }
            return null;
        }

        @Override
        protected void onInitialized(@Nullable Float scale) {
            if (this.isNotNull()) {
                JBUI.setUserScaleFactor(ObjectUtils.notNull(scale).floatValue());
            }
        }
    };
    private static float userScaleFactor = JBUI.setUserScaleFactor(UIUtil.isJreHiDPIEnabled() ? 1.0f : SYSTEM_SCALE_FACTOR.get().floatValue());
    private static final JBEmptyBorder SHARED_EMPTY_INSTANCE = new JBEmptyBorder(0);

    public static void addPropertyChangeListener(@NotNull String propertyName, @NotNull PropertyChangeListener listener) {
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            JBUI.$$$reportNull$$$0(1);
        }
        PCS.addPropertyChangeListener(propertyName, listener);
    }

    public static float sysScale() {
        return SYSTEM_SCALE_FACTOR.get().floatValue();
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (UIUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() == 0) {
            if (SystemInfo.isMac && UIUtil.isJreHiDPI_earlierVersion()) {
                return UIUtil.DetectRetinaKit.isOracleMacRetinaDevice(gc.getDevice()) ? 2.0f : 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (UIUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return (float)g.getTransform().getScaleX();
            }
            return JBUI.sysScale(gc);
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Component comp2) {
        if (comp2 != null) {
            return JBUI.sysScale(comp2.getGraphicsConfiguration());
        }
        return JBUI.sysScale();
    }

    public static double sysScale(@Nullable ScaleContext ctx) {
        if (ctx != null) {
            return ctx.getScale(ScaleType.SYS_SCALE);
        }
        return JBUI.sysScale();
    }

    private static void setUserScaleFactorProperty(float scale) {
        if (userScaleFactor == scale) {
            return;
        }
        Float f = Float.valueOf(userScaleFactor);
        userScaleFactor = scale;
        PCS.firePropertyChange("JBUI.userScaleFactor", f, Float.valueOf(userScaleFactor));
        LOG.info("User scale factor: " + userScaleFactor);
    }

    public static float setUserScaleFactor(float scale) {
        if (DEBUG_USER_SCALE_FACTOR.isNotNull()) {
            float debugScale = ObjectUtils.notNull(DEBUG_USER_SCALE_FACTOR.get()).floatValue();
            if (scale == debugScale) {
                JBUI.setUserScaleFactorProperty(debugScale);
            }
            return debugScale;
        }
        if (!SystemProperties.getBooleanProperty("hidpi", true)) {
            JBUI.setUserScaleFactorProperty(1.0f);
            return 1.0f;
        }
        if ((scale = JBUI.discreteScale(scale)) < 1.0f && JBUI.sysScale() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfo.isLinux && scale == 1.25f && UIUtil.DEF_SYSTEM_FONT_SIZE == 12.0f) {
            scale = 1.0f;
        }
        JBUI.setUserScaleFactorProperty(scale);
        return scale;
    }

    static float discreteScale(float scale) {
        return (float)Math.round(scale / 0.25f) * 0.25f;
    }

    public static float scale(float f) {
        return f * userScaleFactor;
    }

    public static int scale(int i) {
        return Math.round(userScaleFactor * (float)i);
    }

    public static float getFontScale(float fontSize) {
        return fontSize / UIUtil.DEF_SYSTEM_FONT_SIZE;
    }

    @NotNull
    public static JBInsets insets(int top, int left, int bottom, int right) {
        JBInsets jBInsets = new JBInsets(top, left, bottom, right);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(10);
        }
        return jBInsets;
    }

    @NotNull
    public static <T extends JBIcon> T scale(@NotNull T icon) {
        if (icon == null) {
            JBUI.$$$reportNull$$$0(19);
        }
        JBIcon jBIcon = icon.withIconPreScaled(false);
        if (jBIcon == null) {
            JBUI.$$$reportNull$$$0(20);
        }
        return (T)jBIcon;
    }

    public static boolean isHiDPI(double scale) {
        return scale > 1.0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultIcon";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "value";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "uiIntValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "size";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "insets";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInsets";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsTop";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsLeft";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsBottom";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsRight";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "emptySize";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uiIntValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "insets";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "asUIResource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBorder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class RasterJBIcon
    extends ScaleContextSupport<ScaleContext>
    implements CopyableIcon {
        public RasterJBIcon() {
            super(ScaleContext.create());
        }
    }

    public static abstract class CachingScalableJBIcon<T extends CachingScalableJBIcon>
    extends ScalableJBIcon
    implements CopyableIcon {
        private T myScaledIconCache;

        protected CachingScalableJBIcon() {
        }

        protected CachingScalableJBIcon(@NotNull CachingScalableJBIcon icon) {
            if (icon == null) {
                CachingScalableJBIcon.$$$reportNull$$$0(0);
            }
            super(icon);
        }

        @NotNull
        public T scale(float scale) {
            if (scale == this.getScale()) {
                CachingScalableJBIcon cachingScalableJBIcon = this;
                if (cachingScalableJBIcon == null) {
                    CachingScalableJBIcon.$$$reportNull$$$0(1);
                }
                return (T)cachingScalableJBIcon;
            }
            if (this.myScaledIconCache == null || ((ScalableJBIcon)this.myScaledIconCache).getScale() != scale) {
                this.myScaledIconCache = this.copy();
                ((ScaleContextSupport)this.myScaledIconCache).updateScale(ScaleType.OBJ_SCALE.of(scale));
            }
            T t = this.myScaledIconCache;
            if (t == null) {
                CachingScalableJBIcon.$$$reportNull$$$0(2);
            }
            return t;
        }

        @NotNull
        public abstract T copy();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$CachingScalableJBIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$CachingScalableJBIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ScalableJBIcon
    extends JBIcon
    implements ScalableIcon {
        protected ScalableJBIcon() {
        }

        protected ScalableJBIcon(@NotNull ScalableJBIcon icon) {
            if (icon == null) {
                ScalableJBIcon.$$$reportNull$$$0(0);
            }
            super(icon);
        }

        public float getScale() {
            return (float)this.getScale(ScaleType.OBJ_SCALE);
        }

        @Override
        @NotNull
        public Icon scale(float scale) {
            this.updateScale(ScaleType.OBJ_SCALE.of(scale));
            ScalableJBIcon scalableJBIcon = this;
            if (scalableJBIcon == null) {
                ScalableJBIcon.$$$reportNull$$$0(1);
            }
            return scalableJBIcon;
        }

        @Override
        protected double scaleVal(double value) {
            return this.scaleVal(value, ScaleType.PIX_SCALE);
        }

        /*
         * WARNING - void declaration
         */
        protected double scaleVal(double value, @NotNull ScaleType scaleType) {
            void type2;
            if (scaleType == null) {
                ScalableJBIcon.$$$reportNull$$$0(2);
            }
            switch (3.$SwitchMap$com$intellij$util$ui$JBUI$ScaleType[type2.ordinal()]) {
                case 1: {
                    return super.scaleVal(value);
                }
                case 2: {
                    return value * this.getScale(ScaleType.SYS_SCALE);
                }
                case 3: {
                    return value * this.getScale(ScaleType.OBJ_SCALE);
                }
                case 4: {
                    return super.scaleVal(value * this.getScale(ScaleType.OBJ_SCALE));
                }
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScalableJBIcon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScalableJBIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "scaleVal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class JBIcon
    extends ScaleContextSupport<BaseScaleContext>
    implements Icon {
        private final Scaler myScaler;
        private boolean autoUpdateScaleContext;

        protected JBIcon() {
            super(BaseScaleContext.create());
            this.myScaler = new Scaler(){

                @Override
                protected double currentScale() {
                    if (JBIcon.this.autoUpdateScaleContext) {
                        ((BaseScaleContext)JBIcon.this.getScaleContext()).update();
                    }
                    return JBIcon.this.getScale(ScaleType.USR_SCALE);
                }
            };
            this.autoUpdateScaleContext = true;
        }

        protected JBIcon(@NotNull JBIcon icon) {
            if (icon == null) {
                JBIcon.$$$reportNull$$$0(0);
            }
            this();
            this.updateScaleContext((BaseScaleContext)icon.getScaleContext());
            this.myScaler.update(icon.myScaler);
            this.autoUpdateScaleContext = icon.autoUpdateScaleContext;
        }

        protected boolean isIconPreScaled() {
            return this.myScaler.isPreScaled();
        }

        protected void setIconPreScaled(boolean preScaled) {
            this.myScaler.setPreScaled(preScaled);
        }

        @NotNull
        public JBIcon withIconPreScaled(boolean preScaled) {
            this.setIconPreScaled(preScaled);
            JBIcon jBIcon = this;
            if (jBIcon == null) {
                JBIcon.$$$reportNull$$$0(1);
            }
            return jBIcon;
        }

        protected double scaleVal(double value) {
            return this.myScaler.scaleVal(value);
        }

        protected void setAutoUpdateScaleContext(boolean autoUpdate) {
            this.autoUpdateScaleContext = autoUpdate;
        }

        public String toString() {
            return this.getClass().getName() + " " + this.getIconWidth() + "x" + this.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$JBIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$JBIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIconPreScaled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ScaleContextSupport<T extends BaseScaleContext>
    implements ScaleContextAware {
        @NotNull
        private final T myScaleContext;

        public ScaleContextSupport(@NotNull T ctx) {
            if (ctx == null) {
                ScaleContextSupport.$$$reportNull$$$0(0);
            }
            this.myScaleContext = ctx;
        }

        @NotNull
        public T getScaleContext() {
            T t = this.myScaleContext;
            if (t == null) {
                ScaleContextSupport.$$$reportNull$$$0(1);
            }
            return t;
        }

        @Override
        public boolean updateScaleContext(@Nullable BaseScaleContext ctx) {
            return ((BaseScaleContext)this.myScaleContext).update(ctx);
        }

        public double getScale(@NotNull ScaleType type2) {
            if (type2 == null) {
                ScaleContextSupport.$$$reportNull$$$0(2);
            }
            return ((BaseScaleContext)this.getScaleContext()).getScale(type2);
        }

        public boolean updateScale(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContextSupport.$$$reportNull$$$0(3);
            }
            return ((BaseScaleContext)this.getScaleContext()).update(scale);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScaleContextSupport";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScaleContextSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScaleContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getScale";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateScale";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ScaleContextAware {
        public boolean updateScaleContext(@Nullable BaseScaleContext var1);
    }

    public static class ScaleContext
    extends BaseScaleContext {
        protected Scale sysScale;
        @Nullable
        private WeakReference<Component> compRef;

        private ScaleContext() {
            this.sysScale = ScaleType.SYS_SCALE.of(JBUI.sysScale());
            this.update(this.pixScale, this.derivePixScale());
        }

        private ScaleContext(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(0);
            }
            this.sysScale = ScaleType.SYS_SCALE.of(JBUI.sysScale());
            switch (scale.type) {
                case USR_SCALE: {
                    this.update(this.usrScale, scale.value);
                    break;
                }
                case SYS_SCALE: {
                    this.update(this.sysScale, scale.value);
                    break;
                }
                case OBJ_SCALE: {
                    this.update(this.objScale, scale.value);
                    break;
                }
            }
            this.update(this.pixScale, this.derivePixScale());
        }

        @NotNull
        public static ScaleContext createIdentity() {
            ScaleContext scaleContext = ScaleContext.create(ScaleType.USR_SCALE.of(1.0), ScaleType.SYS_SCALE.of(1.0));
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(1);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@Nullable Component comp2) {
            ScaleContext ctx = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(comp2)));
            if (comp2 != null) {
                ctx.compRef = new WeakReference<Component>(comp2);
            }
            ScaleContext scaleContext = ctx;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(3);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@Nullable Component component, @Nullable Graphics2D graphics) {
            GraphicsConfiguration gc;
            if (component != null && ((gc = component.getGraphicsConfiguration()) == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1)) {
                component = null;
            }
            if (component != null) {
                ScaleContext scaleContext = ScaleContext.create(component);
                if (scaleContext == null) {
                    ScaleContext.$$$reportNull$$$0(4);
                }
                return scaleContext;
            }
            ScaleContext scaleContext = ScaleContext.create(graphics);
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(5);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(Graphics2D g) {
            ScaleContext scaleContext = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(g)));
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(7);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(Scale ... scales) {
            if (scales == null) {
                ScaleContext.$$$reportNull$$$0(10);
            }
            ScaleContext ctx = ScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            ScaleContext scaleContext = ctx;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(11);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create() {
            ScaleContext scaleContext = new ScaleContext();
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(12);
            }
            return scaleContext;
        }

        @Override
        protected double derivePixScale() {
            return UIUtil.isJreHiDPIEnabled() ? this.sysScale.value * super.derivePixScale() : super.derivePixScale();
        }

        @Override
        public double getScale(@NotNull ScaleType type2) {
            if (type2 == null) {
                ScaleContext.$$$reportNull$$$0(13);
            }
            if (type2 == ScaleType.SYS_SCALE) {
                return this.sysScale.value;
            }
            return super.getScale(type2);
        }

        @Override
        public boolean update() {
            Component comp2;
            boolean updated = this.update(this.usrScale, JBUI.scale(1.0f));
            if (this.compRef != null && (comp2 = (Component)this.compRef.get()) != null) {
                updated = this.update(this.sysScale, JBUI.sysScale(comp2)) || updated;
            }
            return this.onUpdated(updated);
        }

        @Override
        public boolean update(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(14);
            }
            if (scale.type == ScaleType.SYS_SCALE) {
                return this.onUpdated(this.update(this.sysScale, scale.value));
            }
            return super.update(scale);
        }

        @Override
        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            if (ctx == null) {
                ScaleContext.$$$reportNull$$$0(15);
            }
            boolean updated = super.updateAll(ctx);
            if (!(ctx instanceof ScaleContext)) {
                return updated;
            }
            ScaleContext context = (ScaleContext)ctx;
            if (this.compRef != null) {
                this.compRef.clear();
            }
            this.compRef = context.compRef;
            return this.update(this.sysScale, context.sysScale.value) || updated;
        }

        @Override
        protected boolean update(@NotNull Scale scale, double value) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(16);
            }
            if (scale.type == ScaleType.SYS_SCALE) {
                Scale newScale = scale.newOrThis(value);
                if (newScale == scale) {
                    return false;
                }
                this.sysScale = newScale;
                return true;
            }
            return super.update(scale, value);
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScaleContext) {
                ScaleContext that = (ScaleContext)obj;
                return that.sysScale.value == this.sysScale.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Double.valueOf(this.sysScale.value).hashCode() * 100 + super.hashCode();
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.compRef != null) {
                this.compRef.clear();
            }
        }

        @Override
        @NotNull
        public <T extends BaseScaleContext> T copy() {
            ScaleContext ctx = ScaleContext.createIdentity();
            ctx.updateAll(this);
            ScaleContext scaleContext = ctx;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(17);
            }
            return (T)scaleContext;
        }

        @Override
        public String toString() {
            return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScaleContext";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scales";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScaleContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIdentity";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 17: {
                    break;
                }
                case 8: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getScale";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BaseScaleContext {
        protected Scale usrScale = ScaleType.USR_SCALE.of(JBUI.scale(1.0f));
        protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0);
        protected Scale pixScale = ScaleType.PIX_SCALE.of(Scale.access$200(this.usrScale));
        private List<UpdateListener> listeners;

        private BaseScaleContext() {
        }

        public static BaseScaleContext createIdentity() {
            return BaseScaleContext.create(ScaleType.USR_SCALE.of(1.0));
        }

        @NotNull
        public static BaseScaleContext create(Scale ... scales) {
            if (scales == null) {
                BaseScaleContext.$$$reportNull$$$0(0);
            }
            BaseScaleContext ctx = BaseScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            BaseScaleContext baseScaleContext = ctx;
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(1);
            }
            return baseScaleContext;
        }

        @NotNull
        public static BaseScaleContext create() {
            BaseScaleContext baseScaleContext = new BaseScaleContext();
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(2);
            }
            return baseScaleContext;
        }

        protected double derivePixScale() {
            return this.usrScale.value * this.objScale.value;
        }

        public double getScale(@NotNull ScaleType type2) {
            if (type2 == null) {
                BaseScaleContext.$$$reportNull$$$0(4);
            }
            switch (type2) {
                case USR_SCALE: {
                    return this.usrScale.value;
                }
                case SYS_SCALE: {
                    return 1.0;
                }
                case OBJ_SCALE: {
                    return this.objScale.value;
                }
                case PIX_SCALE: {
                    return this.pixScale.value;
                }
            }
            return 1.0;
        }

        protected boolean onUpdated(boolean updated) {
            if (updated) {
                this.update(this.pixScale, this.derivePixScale());
                this.notifyUpdateListeners();
            }
            return updated;
        }

        public boolean update() {
            return this.onUpdated(this.update(this.usrScale, JBUI.scale(1.0f)));
        }

        public boolean update(@NotNull Scale scale) {
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(6);
            }
            boolean updated = false;
            switch (scale.type) {
                case USR_SCALE: {
                    updated = this.update(this.usrScale, scale.value);
                    break;
                }
                case SYS_SCALE: {
                    break;
                }
                case OBJ_SCALE: {
                    updated = this.update(this.objScale, scale.value);
                    break;
                }
            }
            return this.onUpdated(updated);
        }

        public boolean update(@Nullable BaseScaleContext ctx) {
            if (ctx == null) {
                return this.update();
            }
            return this.onUpdated(this.updateAll(ctx));
        }

        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            if (ctx == null) {
                BaseScaleContext.$$$reportNull$$$0(7);
            }
            boolean updated = this.update(this.usrScale, ctx.usrScale.value);
            return this.update(this.objScale, ctx.objScale.value) || updated;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BaseScaleContext)) {
                return false;
            }
            BaseScaleContext that = (BaseScaleContext)obj;
            return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
        }

        public int hashCode() {
            return Double.valueOf(this.usrScale.value).hashCode() * 10 + Double.valueOf(this.objScale.value).hashCode();
        }

        public void dispose() {
            this.listeners = null;
        }

        public void addUpdateListener(@NotNull UpdateListener l) {
            if (l == null) {
                BaseScaleContext.$$$reportNull$$$0(8);
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<UpdateListener>(1);
            }
            this.listeners.add(l);
        }

        protected void notifyUpdateListeners() {
            if (this.listeners == null) {
                return;
            }
            for (UpdateListener l : this.listeners) {
                l.contextUpdated();
            }
        }

        protected boolean update(@NotNull Scale scale, double value) {
            Scale newScale;
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(10);
            }
            if ((newScale = scale.newOrThis(value)) == scale) {
                return false;
            }
            switch (scale.type) {
                case USR_SCALE: {
                    this.usrScale = newScale;
                    break;
                }
                case OBJ_SCALE: {
                    this.objScale = newScale;
                    break;
                }
                case PIX_SCALE: {
                    this.pixScale = newScale;
                }
            }
            return true;
        }

        @NotNull
        public <T extends BaseScaleContext> T copy() {
            BaseScaleContext ctx = BaseScaleContext.createIdentity();
            ctx.updateAll(this);
            BaseScaleContext baseScaleContext = ctx;
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(11);
            }
            return (T)baseScaleContext;
        }

        public String toString() {
            return this.usrScale + ", " + this.objScale + ", " + this.pixScale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scales";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$BaseScaleContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$BaseScaleContext";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getScale";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAll";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addUpdateListener";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removeUpdateListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static interface UpdateListener {
            public void contextUpdated();
        }
    }

    public static abstract class Scaler {
        protected double initialScale = this.currentScale();

        private double alignedScale() {
            return this.currentScale() / this.initialScale;
        }

        protected boolean isPreScaled() {
            return this.initialScale != 1.0;
        }

        protected void setPreScaled(boolean preScaled) {
            this.initialScale = preScaled ? this.currentScale() : 1.0;
        }

        public double scaleVal(double value) {
            return value * this.alignedScale();
        }

        protected abstract double currentScale();

        public boolean update(@NotNull Scaler scaler) {
            if (scaler == null) {
                Scaler.$$$reportNull$$$0(0);
            }
            boolean updated = this.initialScale != scaler.initialScale;
            this.initialScale = scaler.initialScale;
            return updated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scaler", "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$Scaler", "update"));
        }
    }

    public static class Fonts {
        @NotNull
        public static JBFont label() {
            JBFont jBFont = JBFont.create(UIManager.getFont("Label.font"), false);
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(0);
            }
            return jBFont;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$Fonts";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "label";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "smallFont";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "miniFont";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toolbarFont";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toolbarSmallComboBoxFont";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Scale {
        private final double value;
        private final ScaleType type;
        private static final ThreadLocal<EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>> cache = new ThreadLocal<EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>>(){

            @Override
            protected EnumMap<ScaleType, TDoubleObjectHashMap<Scale>> initialValue() {
                return new EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>(ScaleType.class);
            }
        };

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Scale create(double value, @NotNull ScaleType scaleType) {
            Scale scale;
            void type2;
            EnumMap<ScaleType, TDoubleObjectHashMap<Scale>> emap;
            TDoubleObjectHashMap map2;
            if (scaleType == null) {
                Scale.$$$reportNull$$$0(0);
            }
            if ((map2 = (emap = cache.get()).get(type2)) == null) {
                map2 = new TDoubleObjectHashMap();
                emap.put((ScaleType)type2, (TDoubleObjectHashMap<Scale>)map2);
            }
            if ((scale = (Scale)map2.get(value)) != null) {
                Scale scale2 = scale;
                if (scale2 == null) {
                    Scale.$$$reportNull$$$0(1);
                }
                return scale2;
            }
            scale = new Scale(value, (ScaleType)type2);
            map2.put(value, (Object)scale);
            Scale scale3 = scale;
            if (scale3 == null) {
                Scale.$$$reportNull$$$0(2);
            }
            return scale3;
        }

        /*
         * WARNING - void declaration
         */
        private Scale(double value, @NotNull ScaleType scaleType) {
            void type2;
            if (scaleType == null) {
                Scale.$$$reportNull$$$0(3);
            }
            this.value = value;
            this.type = type2;
        }

        @NotNull
        Scale newOrThis(double value) {
            if (this.value == value) {
                Scale scale = this;
                if (scale == null) {
                    Scale.$$$reportNull$$$0(5);
                }
                return scale;
            }
            Scale scale = this.type.of(value);
            if (scale == null) {
                Scale.$$$reportNull$$$0(6);
            }
            return scale;
        }

        public String toString() {
            return "[" + this.type.name() + " " + this.value + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$Scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$Scale";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newOrThis";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ScaleType {
        USR_SCALE,
        SYS_SCALE,
        OBJ_SCALE,
        PIX_SCALE;


        @NotNull
        public Scale of(double value) {
            Scale scale = Scale.create(value, this);
            if (scale == null) {
                ScaleType.$$$reportNull$$$0(0);
            }
            return scale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ui/JBUI$ScaleType", "of"));
        }
    }
}

