/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.Fixed;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.method.DynamicParameter;
import org.eclipse.sensinact.gateway.core.method.DynamicParameterValue;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.builder.DynamicParameterValueFactory;
import org.eclipse.sensinact.gateway.generic.parser.ConstrainableDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ConstraintDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ParameterBuilderDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ResolvedNameTypeValueDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlEscaped;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@XmlEscaped(value={"constraints"})
public class ParameterDefinition
extends ResolvedNameTypeValueDefinition
implements ConstrainableDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterDefinition.class);
    private LinkedList<ConstraintDefinition> constraintDefinitions = new LinkedList();
    private ParameterBuilderDefinition builder;
    private boolean fixed = false;

    ParameterDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    public boolean isModifiable() {
        return !this.fixed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(ResourceImpl resource, ServiceImpl service) throws InvalidValueException {
        Parameter parameter = null;
        try {
            if (this.builder != null) {
                DynamicParameterValue dynamic = null;
                DynamicParameterValueFactory.Loader loader = (DynamicParameterValueFactory.Loader)DynamicParameterValueFactory.LOADER.get();
                try {
                    DynamicParameterValueFactory factory = loader.load(this.mediator, this.builder.getName());
                    JSONObject builderDefinitionJSON = new JSONObject(this.builder.getJSON());
                    JSONObject builderJSON = builderDefinitionJSON.getJSONObject("builder");
                    String reference = this.builder.getReference();
                    Executable valueExtractor = null;
                    if (reference.startsWith("./")) {
                        String attributeReference = reference.substring(2);
                        valueExtractor = resource.getResourceValueExtractor(attributeReference);
                    } else {
                        valueExtractor = service.getResourceValueExtractor(this.builder.getReference());
                    }
                    dynamic = factory.newInstance(this.mediator, valueExtractor, builderJSON);
                }
                finally {
                    DynamicParameterValueFactory.LOADER.remove();
                }
                parameter = new DynamicParameter(this.mediator, this.name, (Class)super.getType(), dynamic);
                return parameter;
            }
            Object fixedValue = null;
            Iterator iterator = this.constraintDefinitions.iterator();
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            while (iterator.hasNext()) {
                try {
                    Constraint constraint = ((ConstraintDefinition)iterator.next()).getConstraint((Class)super.getType());
                    if (Fixed.class.isAssignableFrom(constraint.getClass())) {
                        fixedValue = ((Fixed)constraint).getValue();
                        break;
                    }
                    constraints.add(constraint);
                }
                catch (InvalidConstraintDefinitionException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            parameter = fixedValue == null ? new Parameter(this.mediator, super.getName(), (Class)super.getType(), constraints) : new Parameter(this.mediator, super.getName(), (Class)super.getType(), fixedValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parameter;
    }

    @Override
    public void addConstraint(ConstraintDefinition constraint) {
        if (Fixed.class.isAssignableFrom(constraint.getClass())) {
            this.fixed = true;
        }
        this.constraintDefinitions.add(constraint);
    }

    public void setBuilder(ParameterBuilderDefinition builder) {
        this.fixed = true;
        this.builder = builder;
    }

    public ParameterBuilderDefinition getBuilder() {
        return this.builder;
    }

    public void builderStart(Attributes atts) {
        ParameterBuilderDefinition builder;
        this.builder = builder = new ParameterBuilderDefinition(this.mediator, this.getName(), atts);
        super.setNext(builder);
    }
}

