/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.internal;

import java.security.InvalidKeyException;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.sensinact.gateway.commands.gogo.internal.DeviceCommands;
import org.eclipse.sensinact.gateway.commands.gogo.internal.ResourceCommands;
import org.eclipse.sensinact.gateway.commands.gogo.internal.ServiceCommands;
import org.eclipse.sensinact.gateway.commands.gogo.osgi.CommandServiceMediator;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.util.UriUtils;

public class DescribeCommands {
    private CommandServiceMediator mediator;

    public DescribeCommands(CommandServiceMediator mediator) throws DataStoreException, InvalidKeyException {
        this.mediator = mediator;
    }

    @Descriptor(value="display the information regarding the URL")
    public void describe(@Descriptor(value="the URL (starting with \"/\"") String url) throws DataStoreException, InvalidKeyException {
        String[] uriElements = UriUtils.getUriElements((String)url);
        switch (uriElements.length) {
            case 1: {
                if (uriElements[0].equals("providers")) {
                    new DeviceCommands(this.mediator).devices();
                    break;
                }
                new DeviceCommands(this.mediator).device(uriElements[0]);
                break;
            }
            case 2: {
                if (uriElements[1].equals("services")) {
                    new ServiceCommands(this.mediator).services(uriElements[0]);
                    break;
                }
                new ServiceCommands(this.mediator).service(uriElements[0], uriElements[1]);
                break;
            }
            case 3: {
                if (uriElements[2].equals("resources")) {
                    new ResourceCommands(this.mediator).resources(uriElements[0], uriElements[1]);
                    break;
                }
                new ResourceCommands(this.mediator).resource(uriElements[0], uriElements[1], uriElements[2]);
                break;
            }
            default: {
                System.out.println("Invalid URL parameter");
            }
        }
    }
}

