/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.location.test;

import org.eclipse.sensinact.gateway.util.LocationUtils;
import org.eclipse.sensinact.gateway.util.location.Point;
import org.eclipse.sensinact.gateway.util.location.Segment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocationUtilsTest {
    @Test
    public void testDistanceCalulation() {
        Segment segment = LocationUtils.getElipsoidEarthModelDistance((double)45.1855758793, (double)5.7326316833, (double)45.1887820012, (double)5.740571022);
        double distance = LocationUtils.getDistance((double)45.1855758793, (double)5.7326316833, (double)45.1887820012, (double)5.740571022);
        int distanceInt = (int)Math.round(distance);
        Assertions.assertTrue(((double)Math.abs(719 - distanceInt) < 5.0 ? 1 : 0) != 0);
        distance = segment.getDistance();
        distanceInt = (int)Math.round(distance);
        Assertions.assertTrue(((double)Math.abs(719 - distanceInt) < 5.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionFinding() {
        Segment segment1 = LocationUtils.getElipsoidEarthModelDistance((double)45.187972926197865, (double)5.733747482299805, (double)45.189719606541445, (double)5.735764503479004);
        Segment segment2 = LocationUtils.getElipsoidEarthModelDistance((double)45.18810147160006, (double)5.7350993156433105, (double)45.19002205656789, (double)5.7336509227752686);
        Segment intersection = LocationUtils.getSegmentIntersection((Segment)segment1, (Segment)segment2);
        double latitude = intersection.getLat2();
        double longitude = intersection.getLng2();
        double lat = 45.188736632855935;
        double lng = 5.734624564647675;
        double d = LocationUtils.getDistance((double)latitude, (double)longitude, (double)lat, (double)lng);
        System.out.println(latitude + "," + longitude);
        System.out.println(d);
        System.out.println(intersection.toString());
        Assertions.assertTrue((Math.abs(d) < 5.0 ? 1 : 0) != 0);
    }

    @Test
    public void testEFAPDecoding() {
        Assertions.assertEquals((double)-179.98321, (double)((Double)LocationUtils.fromEPAF((String)"`~oia@").get(0)), (double)1.0E-5);
        Assertions.assertEquals((Object)"[38.5, -120.2, 40.7, -120.95, 43.252, -126.453]", (Object)LocationUtils.fromEPAF((String)"_p~iF~ps|U_ulLnnqC_mqNvxq`@").toString());
        Assertions.assertEquals((int)68, (int)LocationUtils.epafToPoints((String)"skyrGe~_b@K_@KYI_@CYA]A[@S@UJBFb@LRJDNDJ?b@KNKb@Wj@]vA{@NMLKvAsA^]BCnBaCLOFN\\[z@]r@Kv@DbAFDB^TJE`Bk@nAc@HEHNDFJRbAfB~@dBv@rAHLV`@JZHQDGV@HCHKfAQB?HALA?P\\rAFV?VRt@Tx@Lb@V^U`@IPj@nB").size());
    }

    @Test
    public void testEFAPEncoding() {
        Assertions.assertEquals((Object)"`~oia@", (Object)LocationUtils.toEPAF((double)-179.9832104));
        Assertions.assertEquals((Object)"_p~iF~ps|U_ulLnnqC_mqNvxq`@", (Object)LocationUtils.toEPAF((Point[])new Point[]{new Point(38.5, -120.2), new Point(40.7, -120.95), new Point(43.252, -126.453)}));
    }
}

