/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

public class UriUtils {
    public static final String WILDCARD = "*";
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT = "/";

    public static String[] getUriElements(String uri) {
        String formatedUri = UriUtils.formatUri(uri);
        if (formatedUri == "/") {
            return new String[0];
        }
        String[] elements = formatedUri.split("/");
        String[] uriElements = new String[elements.length - 1];
        System.arraycopy(elements, 1, uriElements, 0, elements.length - 1);
        return uriElements;
    }

    public static String getUri(String[] uriElements) {
        int length = uriElements == null ? 0 : uriElements.length;
        StringBuilder uriBuilder = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            if (uriElements[index] == null || uriElements[index].trim().length() == 0) continue;
            uriBuilder.append(uriElements[index].startsWith("/") ? "" : "/");
            uriBuilder.append(uriElements[index]);
        }
        return uriBuilder.toString();
    }

    public static String getRoot(String uri) {
        String formatedUri = UriUtils.formatUri(uri);
        if (formatedUri.intern() == "/".intern()) {
            return "/";
        }
        String[] uriElements = formatedUri.split("/");
        int length = 2;
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            if (uriElements[index] == null || uriElements[index].length() == 0) continue;
            buffer.append("/");
            buffer.append(uriElements[index]);
        }
        return UriUtils.formatUri(buffer.toString());
    }

    public static String getParentUri(String uri) {
        String formatedUri = UriUtils.formatUri(uri);
        if (formatedUri.intern() == "/".intern()) {
            return "/";
        }
        String[] uriElements = formatedUri.split("/");
        int length = uriElements.length - 1;
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            if (uriElements[index] == null || uriElements[index].length() == 0) continue;
            buffer.append("/");
            buffer.append(uriElements[index]);
        }
        return UriUtils.formatUri(buffer.toString());
    }

    public static String getChildUri(String uri) {
        StringBuilder buffer = new StringBuilder();
        String formatedUri = UriUtils.formatUri(uri);
        if (formatedUri.intern() == "/".intern()) {
            return "/";
        }
        String[] uriElements = formatedUri.split("/");
        int length = uriElements.length;
        for (int index = 2; index < length; ++index) {
            if (uriElements[index] == null || uriElements[index].length() == 0) continue;
            buffer.append("/");
            buffer.append(uriElements[index]);
        }
        if (buffer.length() == 0) {
            return "/";
        }
        return buffer.toString();
    }

    public static String getLeaf(String uri) {
        String formatedUri = UriUtils.formatUri(uri);
        if (formatedUri.intern() == "/".intern()) {
            return "/";
        }
        String[] uriElements = formatedUri.split("/");
        return uriElements[uriElements.length - 1];
    }

    public static String formatUri(String uri) {
        String formatedUri = null;
        if (uri == null) {
            return "/";
        }
        formatedUri = new String(uri.trim());
        if (!formatedUri.startsWith("/")) {
            formatedUri = "/" + formatedUri;
        }
        if (formatedUri.length() > 1 && formatedUri.endsWith("/")) {
            formatedUri = formatedUri.substring(0, formatedUri.length() - 1);
        }
        if (formatedUri.length() == 1) {
            return "/";
        }
        return formatedUri;
    }
}

