/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.test.configuration.osgi;

import java.util.ConcurrentModificationException;
import java.util.List;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        String codeBase = context.getProperty("org.eclipse.sensinact.gateway.test.codeBase");
        if (codeBase == null || codeBase.length() == 0) {
            return;
        }
        String[] codeBases = codeBase.split(",");
        ServiceReference sRef = context.getServiceReference(ConditionalPermissionAdmin.class);
        ConditionalPermissionAdmin cpa = null;
        if (sRef == null) {
            throw new BundleException("ConditionalPermissionAdmin services needed");
        }
        cpa = (ConditionalPermissionAdmin)context.getService(sRef);
        ConditionalPermissionUpdate cpu = cpa.newConditionalPermissionUpdate();
        List piList = cpu.getConditionalPermissionInfos();
        int length = codeBases.length;
        for (int index = 0; index < length; ++index) {
            piList.add(cpa.newConditionalPermissionInfo(String.format("ALLOW {[org.eclipse.sensinact.gateway.core.security.perm.CodeBaseCondition \"%s\"](java.security.AllPermission \"\" \"\")} null", codeBases[index])));
        }
        if (!cpu.commit()) {
            throw new ConcurrentModificationException("Permissions changed during update");
        }
    }

    public void stop(BundleContext context) throws Exception {
    }
}

