/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationParser {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationParser.class);
    private Properties m_properties = new Properties();

    ConfigurationParser() {
    }

    void parse(File file) throws ParseException {
        if (file == null) {
            LOG.warn("parsing NULL file, so fallback on default configuration!");
            return;
        }
        if (!file.exists()) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()));
            return;
        }
        try {
            FileReader reader = new FileReader(file);
            this.parse(reader);
        }
        catch (FileNotFoundException fex) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()), (Throwable)fex);
            return;
        }
    }

    void parse(Reader reader) throws ParseException {
        if (reader == null) {
            LOG.warn("parsing NULL reader, so fallback on default configuration!");
            return;
        }
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int commentMarker = line.indexOf(35);
                if (commentMarker != -1) {
                    if (commentMarker == 0) continue;
                    throw new ParseException(line, commentMarker);
                }
                if (line.isEmpty() || line.matches("^\\s*$")) continue;
                int delimiterIdx = line.indexOf(32);
                String key = line.substring(0, delimiterIdx).trim();
                String value = line.substring(delimiterIdx).trim();
                this.m_properties.put(key, value);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    Properties getProperties() {
        return this.m_properties;
    }
}

