/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.MessageGUID;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSession {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSession.class);
    public final String clientID;
    private final IMessagesStore messagesStore;
    private final ISessionsStore m_sessionsStore;
    private Set<Subscription> subscriptions = new HashSet<Subscription>();
    private volatile boolean cleanSession;

    public ClientSession(String clientID, IMessagesStore messagesStore, ISessionsStore sessionsStore, boolean cleanSession) {
        this.clientID = clientID;
        this.messagesStore = messagesStore;
        this.m_sessionsStore = sessionsStore;
        this.cleanSession = cleanSession;
    }

    public BlockingQueue<IMessagesStore.StoredMessage> queue() {
        return this.m_sessionsStore.queue(this.clientID);
    }

    public String toString() {
        return "ClientSession{clientID='" + this.clientID + '\'' + "}";
    }

    public boolean subscribe(Subscription newSubscription) {
        LOG.info("<{}> subscribed to the topic filter <{}> with QoS {}", new Object[]{newSubscription.getClientId(), newSubscription.getTopicFilter(), AbstractMessage.QOSType.formatQoS(newSubscription.getRequestedQos())});
        boolean validTopic = SubscriptionsStore.validate(newSubscription.getTopicFilter());
        if (!validTopic) {
            return false;
        }
        ISessionsStore.ClientTopicCouple matchingCouple = new ISessionsStore.ClientTopicCouple(this.clientID, newSubscription.getTopicFilter());
        Subscription existingSub = this.m_sessionsStore.getSubscription(matchingCouple);
        if (existingSub == null || existingSub.getRequestedQos().byteValue() < newSubscription.getRequestedQos().byteValue()) {
            if (existingSub != null) {
                this.subscriptions.remove(newSubscription);
            }
            this.subscriptions.add(newSubscription);
            this.m_sessionsStore.addNewSubscription(newSubscription);
        }
        return true;
    }

    public void unsubscribeFrom(String topicFilter) {
        this.m_sessionsStore.removeSubscription(topicFilter, this.clientID);
        HashSet<Subscription> subscriptionsToRemove = new HashSet<Subscription>();
        for (Subscription sub : this.subscriptions) {
            if (!sub.getTopicFilter().equals(topicFilter)) continue;
            subscriptionsToRemove.add(sub);
        }
        this.subscriptions.removeAll(subscriptionsToRemove);
    }

    public void disconnect() {
        if (this.cleanSession) {
            this.cleanSession();
        }
    }

    public void cleanSession() {
        LOG.info("cleaning old saved subscriptions for client <{}>", (Object)this.clientID);
        this.m_sessionsStore.wipeSubscriptions(this.clientID);
        LOG.debug("Wiped subscriptions for client <{}>", (Object)this.clientID);
        this.messagesStore.dropMessagesInSession(this.clientID);
        LOG.debug("Removed messages in session for client <{}>", (Object)this.clientID);
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void cleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        this.m_sessionsStore.updateCleanStatus(this.clientID, cleanSession);
    }

    public int nextPacketId() {
        return this.m_sessionsStore.nextPacketID(this.clientID);
    }

    public void inFlightAcknowledged(int messageID) {
        LOG.trace("Acknowledging inflight, clientID <{}> messageID {}", (Object)this.clientID, (Object)messageID);
        this.m_sessionsStore.inFlightAck(this.clientID, messageID);
    }

    public void inFlightAckWaiting(MessageGUID guid, int messageID) {
        LOG.trace("Adding to inflight {}, guid <{}>", (Object)messageID, (Object)guid);
        this.m_sessionsStore.inFlight(this.clientID, messageID, guid);
    }

    public IMessagesStore.StoredMessage secondPhaseAcknowledged(int messageID) {
        MessageGUID guid = this.m_sessionsStore.secondPhaseAcknowledged(this.clientID, messageID);
        return this.messagesStore.getMessageByGuid(guid);
    }

    public void enqueue(IMessagesStore.StoredMessage message) {
        this.m_sessionsStore.queue(this.clientID).add(message);
    }

    public IMessagesStore.StoredMessage storedMessage(int messageID) {
        MessageGUID guid = this.m_sessionsStore.mapToGuid(this.clientID, messageID);
        return this.messagesStore.getMessageByGuid(guid);
    }

    public void moveInFlightToSecondPhaseAckWaiting(int messageID) {
        this.m_sessionsStore.moveInFlightToSecondPhaseAckWaiting(this.clientID, messageID);
    }

    public IMessagesStore.StoredMessage getInflightMessage(int messageID) {
        return this.m_sessionsStore.getInflightMessage(this.clientID, messageID);
    }
}

