/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.eclipse.sensinact.gateway.security.signature.internal.KeyStoreManagerException;

public class KeyStoreManager {
    private static final String KEYSTORE_TYPE = "jks";
    private final KeyStore keystore;

    public KeyStoreManager(String keystoreFile, String keyStorePassword) throws KeyStoreManagerException {
        try {
            this.keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            System.out.println(Paths.get(keystoreFile, new String[0]).toAbsolutePath());
            InputStream iStream = Files.newInputStream(Paths.get(keystoreFile, new String[0]).toAbsolutePath(), new OpenOption[0]);
            this.keystore.load(iStream, keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(e);
        }
    }

    public Certificate getCertificate(String subject) throws CertificateException, NoSuchAlgorithmException, FileNotFoundException, KeyStoreException, IOException {
        Certificate cert = null;
        cert = this.keystore.getCertificate(subject);
        return cert;
    }

    public PrivateKey getPrivateKey(String subject, String keyPasswd) throws CertificateException, NoSuchAlgorithmException, FileNotFoundException, KeyStoreException, UnrecoverableKeyException, IOException {
        PrivateKey priv = (PrivateKey)this.keystore.getKey(subject, keyPasswd.toCharArray());
        return priv;
    }

    public boolean isValid(Certificate cert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateNotYetValidException, CertificateExpiredException, CertificateException {
        boolean valid = false;
        String alias = this.keystore.getCertificateAlias(cert);
        if (alias != null) {
            valid = this.isTemporallyOK(cert);
        }
        return valid;
    }

    public boolean isTemporallyOK(Certificate cert) throws CertificateExpiredException, CertificateNotYetValidException {
        boolean valid = false;
        X509Certificate x509 = (X509Certificate)cert;
        try {
            x509.checkValidity();
            valid = true;
        }
        catch (CertificateExpiredException e) {
            e.printStackTrace();
        }
        catch (CertificateNotYetValidException e) {
            e.printStackTrace();
        }
        return valid;
    }
}

