/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpointConfigurator;
import org.eclipse.sensinact.gateway.generic.annotation.SensiNactBridgeConfiguration;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.util.json.JSONValidator;
import org.json.JSONException;

public class SensiNactBridgeConfigurationPojo {
    public static final String DEFAULT_RESOURCE_DEFINITION = "resources.xml";
    public static final Class<? extends Packet> DEFAULT_PACKET_TYPE = Packet.class;
    public static final Class<? extends ProtocolStackEndpoint> DEFAULT_PROTOCOL_STACK_ENDPOINT_TYPE = LocalProtocolStackEndpoint.class;
    public static final boolean DEFAULT_START_AT_INITIALIZATION_TIME = true;
    public static final boolean DEFAULT_OUTPUT_ONLY = false;
    public static final SensiNactResourceModelConfiguration.BuildPolicy[] DEFAULT_SERVICE_BUILD_POLICY = new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION};
    public static final SensiNactResourceModelConfiguration.BuildPolicy[] DEFAULT_RESOURCE_BUILD_POLICY = new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION};
    private final String defaultResourceDefinition;
    private String resourceDefinition;
    private final boolean defaultStartAtInitializationTime;
    private boolean startAtInitializationTime;
    private final boolean defaultOutputOnly;
    private boolean outputOnly;
    private final SensiNactResourceModelConfiguration.BuildPolicy[] defaultServiceBuildPolicy;
    private SensiNactResourceModelConfiguration.BuildPolicy[] serviceBuildPolicy;
    private final SensiNactResourceModelConfiguration.BuildPolicy[] defaultResourceBuildPolicy;
    private SensiNactResourceModelConfiguration.BuildPolicy[] resourceBuildPolicy;
    private final Map<String, String> defaultInitialProviders;
    private Map<String, String> initialProviders;
    private final String[] defaultObserved;
    private String[] observed;
    private final Class<? extends Packet> defaultPacketType;
    private Class<? extends Packet> packetType;
    private final Class<? extends ProtocolStackEndpoint> defaultEndpointType;
    private Class<? extends ProtocolStackEndpoint> endpointType;

    public SensiNactBridgeConfigurationPojo() {
        this.defaultResourceDefinition = DEFAULT_RESOURCE_DEFINITION;
        this.defaultStartAtInitializationTime = true;
        this.isStartAtInitializationTime(this.defaultStartAtInitializationTime);
        this.defaultOutputOnly = false;
        this.isOutputOnly(this.defaultOutputOnly);
        this.defaultServiceBuildPolicy = DEFAULT_SERVICE_BUILD_POLICY;
        this.defaultResourceBuildPolicy = DEFAULT_RESOURCE_BUILD_POLICY;
        this.defaultInitialProviders = Collections.emptyMap();
        this.defaultObserved = new String[0];
        this.defaultPacketType = DEFAULT_PACKET_TYPE;
        this.defaultEndpointType = DEFAULT_PROTOCOL_STACK_ENDPOINT_TYPE;
    }

    public SensiNactBridgeConfigurationPojo(ProtocolStackEndpointConfigurator configurator) {
        this.defaultResourceDefinition = configurator.getDefaultResourceDefinition();
        this.defaultStartAtInitializationTime = configurator.getDefaultStartAtInitializationTime();
        this.isStartAtInitializationTime(this.defaultStartAtInitializationTime);
        this.defaultOutputOnly = configurator.getDefaultOutputOnly();
        this.isOutputOnly(this.defaultOutputOnly);
        this.defaultServiceBuildPolicy = configurator.getDefaultServiceBuildPolicy();
        this.defaultResourceBuildPolicy = configurator.getDefaultResourceBuildPolicy();
        this.defaultInitialProviders = configurator.getDefaultInitialProviders();
        this.defaultObserved = configurator.getDefaultObserved();
        this.defaultPacketType = configurator.getDefaultPacketType();
        this.defaultEndpointType = configurator.getDefaultEndpointType();
    }

    public void populate(String json) {
        if (json != null) {
            ArrayList<String> observedPath = new ArrayList<String>();
            this.initialProviders = new HashMap<String, String>();
            JSONValidator validator = new JSONValidator((Reader)new StringReader(json));
            String packetClass = null;
            String endpointClass = null;
            boolean parsingObserved = false;
            boolean parsingProviders = false;
            String provider = null;
            String profile = null;
            try {
                JSONValidator.JSONToken t;
                while ((t = validator.nextToken()) != null) {
                    switch (t) {
                        case JSON_OBJECT_ITEM: {
                            if (t.getContext().key == null) break;
                            switch (t.getContext().key) {
                                case "providerId": {
                                    if (!parsingProviders) break;
                                    if (profile != null) {
                                        this.initialProviders.put(String.valueOf(t.getContext().value), profile);
                                        profile = null;
                                        break;
                                    }
                                    provider = String.valueOf(t.getContext().value);
                                    break;
                                }
                                case "profileId": {
                                    if (!parsingProviders) break;
                                    if (provider != null) {
                                        this.initialProviders.put(provider, String.valueOf(t.getContext().value));
                                        provider = null;
                                        break;
                                    }
                                    profile = String.valueOf(t.getContext().value);
                                    break;
                                }
                                case "resourceDefinition": {
                                    if (parsingProviders) break;
                                    this.setResourceDefinition(String.valueOf(t.getContext().value));
                                    break;
                                }
                                case "packetType": {
                                    if (parsingProviders) break;
                                    packetClass = String.valueOf(t.getContext().value);
                                    break;
                                }
                                case "endpointType": {
                                    if (parsingProviders) break;
                                    endpointClass = String.valueOf(t.getContext().value);
                                    break;
                                }
                                case "resourceBuildPolicy": {
                                    if (parsingProviders) break;
                                    Object policy = t.getContext().value;
                                    if (policy instanceof String) {
                                        this.setResourceBuildPolicy(new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)((String)policy))});
                                        break;
                                    }
                                    if (!(policy instanceof Byte)) break;
                                    this.setResourceBuildPolicy(SensiNactResourceModelConfiguration.BuildPolicy.valueOf((byte)((Byte)policy)));
                                    break;
                                }
                                case "serviceBuildPolicy": {
                                    if (parsingProviders) break;
                                    Object policy = t.getContext().value;
                                    if (policy instanceof String) {
                                        this.setServiceBuildPolicy(new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)((String)policy))});
                                        break;
                                    }
                                    if (!(policy instanceof Byte)) break;
                                    this.setServiceBuildPolicy(SensiNactResourceModelConfiguration.BuildPolicy.valueOf((byte)((Byte)policy)));
                                    break;
                                }
                                case "startAtInitializationTime": {
                                    if (parsingProviders) break;
                                    this.isStartAtInitializationTime(Boolean.valueOf(String.valueOf(t.getContext().value)));
                                    break;
                                }
                                case "outputOnly": {
                                    if (parsingProviders) break;
                                    this.isOutputOnly(Boolean.valueOf(String.valueOf(t.getContext().value)));
                                }
                            }
                        }
                        case JSON_ARRAY_ITEM: {
                            if (!parsingObserved) break;
                            observedPath.add(String.valueOf(t.getContext().value));
                            break;
                        }
                        case JSON_ARRAY_CLOSING: {
                            if (!parsingObserved) break;
                            parsingObserved = false;
                            this.setObserved(observedPath.toArray(new String[0]));
                            break;
                        }
                        case JSON_ARRAY_OPENING: {
                            if (parsingProviders || parsingObserved) {
                                throw new JSONException("Unexpected array opening bracket");
                            }
                            if (!"observed".equals(t.getContext().key)) break;
                            parsingObserved = true;
                            break;
                        }
                        case JSON_OBJECT_OPENING: {
                            if (parsingProviders || parsingObserved) {
                                throw new JSONException("Unexpected object opening brace");
                            }
                            if (!"initialProviders".equals(t.getContext().key)) break;
                            parsingProviders = true;
                            break;
                        }
                        case JSON_OBJECT_CLOSING: {
                            if (!parsingProviders) break;
                            parsingProviders = false;
                            break;
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (packetClass != null) {
                try {
                    this.setPacketType(loader.loadClass(packetClass));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (endpointClass != null) {
                try {
                    this.setEndpointType(loader.loadClass(endpointClass));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void populate(Dictionary<String, ?> dictionary) {
        if (dictionary != null) {
            Object initialProviders;
            Object resourceBuildPolicy;
            Object serviceBuildPolicy;
            Object observed;
            Object outputOnly;
            Object startAtInitializationTime;
            Object endpointClass;
            Object packetClass;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.initialProviders = new HashMap<String, String>();
            ArrayList<String> observedPath = new ArrayList<String>();
            Object resourceDefinition = dictionary.get("resourceDefinition");
            if (resourceDefinition != null) {
                this.setResourceDefinition(String.valueOf(resourceDefinition));
            }
            if ((packetClass = dictionary.get("packetType")) != null) {
                if (packetClass instanceof Class) {
                    this.setPacketType((Class)packetClass);
                } else {
                    try {
                        this.setPacketType(loader.loadClass(String.valueOf(packetClass)));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((endpointClass = dictionary.get("endpointType")) != null) {
                if (endpointClass instanceof Class) {
                    this.setEndpointType((Class)endpointClass);
                } else {
                    try {
                        this.setEndpointType(loader.loadClass(String.valueOf(endpointClass)));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((startAtInitializationTime = dictionary.get("startAtInitializationTime")) != null) {
                if (startAtInitializationTime instanceof Boolean) {
                    this.isStartAtInitializationTime((Boolean)startAtInitializationTime);
                } else {
                    this.isStartAtInitializationTime(Boolean.valueOf(String.valueOf(startAtInitializationTime)));
                }
            }
            if ((outputOnly = dictionary.get("outputOnly")) != null) {
                if (outputOnly instanceof Boolean) {
                    this.isOutputOnly((Boolean)outputOnly);
                } else {
                    this.isOutputOnly(Boolean.valueOf(String.valueOf(outputOnly)));
                }
            }
            if ((observed = dictionary.get("observed")) != null) {
                if (observed instanceof String[]) {
                    this.setObserved((String[])observed);
                } else {
                    String[] obsArray;
                    String obs = String.valueOf(observed);
                    if (obs.startsWith("[")) {
                        obs = obs.substring(1);
                    }
                    if (obs.endsWith("]")) {
                        obs = obs.substring(0, obs.length() - 1);
                    }
                    for (String o : obsArray = obs.split(",")) {
                        observedPath.add(o.trim());
                    }
                }
            }
            if ((serviceBuildPolicy = dictionary.get("serviceBuildPolicy")) != null) {
                if (serviceBuildPolicy instanceof SensiNactResourceModelConfiguration.BuildPolicy[]) {
                    this.setServiceBuildPolicy((SensiNactResourceModelConfiguration.BuildPolicy[])serviceBuildPolicy);
                } else if (serviceBuildPolicy instanceof String[]) {
                    SensiNactResourceModelConfiguration.BuildPolicy[] sbp = new SensiNactResourceModelConfiguration.BuildPolicy[((String[])serviceBuildPolicy).length];
                    for (int i = 0; i < ((String[])serviceBuildPolicy).length; ++i) {
                        sbp[i] = SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)((String[])serviceBuildPolicy)[i]);
                    }
                    this.setServiceBuildPolicy(sbp);
                } else {
                    String bps = String.valueOf(serviceBuildPolicy);
                    if (bps.startsWith("[")) {
                        bps = bps.substring(1);
                    }
                    if (bps.endsWith("]")) {
                        bps = bps.substring(0, bps.length() - 1);
                    }
                    String[] bpsArray = bps.split(",");
                    SensiNactResourceModelConfiguration.BuildPolicy[] sbp = new SensiNactResourceModelConfiguration.BuildPolicy[bpsArray.length];
                    for (int i = 0; i < ((String[])serviceBuildPolicy).length; ++i) {
                        sbp[i] = SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)bpsArray[i]);
                    }
                    this.setServiceBuildPolicy(sbp);
                }
            }
            if ((resourceBuildPolicy = dictionary.get("resourceBuildPolicy")) != null) {
                if (resourceBuildPolicy instanceof SensiNactResourceModelConfiguration.BuildPolicy[]) {
                    this.setResourceBuildPolicy((SensiNactResourceModelConfiguration.BuildPolicy[])resourceBuildPolicy);
                } else if (resourceBuildPolicy instanceof String[]) {
                    SensiNactResourceModelConfiguration.BuildPolicy[] sbp = new SensiNactResourceModelConfiguration.BuildPolicy[((String[])resourceBuildPolicy).length];
                    for (int i = 0; i < ((String[])resourceBuildPolicy).length; ++i) {
                        sbp[i] = SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)((String[])resourceBuildPolicy)[i]);
                    }
                    this.setResourceBuildPolicy(sbp);
                } else {
                    String bps = String.valueOf(resourceBuildPolicy);
                    if (bps.startsWith("[")) {
                        bps = bps.substring(1);
                    }
                    if (bps.endsWith("]")) {
                        bps = bps.substring(0, bps.length() - 1);
                    }
                    String[] bpsArray = bps.split(",");
                    SensiNactResourceModelConfiguration.BuildPolicy[] sbp = new SensiNactResourceModelConfiguration.BuildPolicy[bpsArray.length];
                    for (int i = 0; i < ((String[])resourceBuildPolicy).length; ++i) {
                        sbp[i] = SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)bpsArray[i]);
                    }
                    this.setResourceBuildPolicy(sbp);
                }
            }
            if ((initialProviders = dictionary.get("initialProviders")) != null) {
                if (initialProviders instanceof Map) {
                    this.setInitialProviders((Map)initialProviders);
                } else if (initialProviders instanceof String[][]) {
                    HashMap<String, String> ips = new HashMap<String, String>();
                    for (int i = 0; i < ((String[][])initialProviders).length; ++i) {
                        ips.put(((String[][])initialProviders)[i][0], ((String[][])initialProviders)[i][1]);
                    }
                    this.setInitialProviders(ips);
                } else if (initialProviders instanceof String[]) {
                    HashMap<String, String> ips = new HashMap<String, String>();
                    for (int i = 0; i < ((String[])initialProviders).length; ++i) {
                        String ip = ((String[])initialProviders)[i];
                        String[] els = ip.split(";");
                        if (els.length != 2) continue;
                        ips.put(els[0], els[1]);
                    }
                    this.setInitialProviders(ips);
                } else if (initialProviders instanceof String) {
                    HashMap<String, String> ips = new HashMap<String, String>();
                    String[] providers = ((String)initialProviders).split(",");
                    for (int i = 0; i < providers.length; ++i) {
                        String ip = providers[i];
                        String[] els = ip.split(";");
                        if (els.length != 2) continue;
                        ips.put(els[0], els[1]);
                    }
                    this.setInitialProviders(ips);
                }
            }
        }
    }

    public void populate(SensiNactBridgeConfiguration annotation) {
        if (annotation != null) {
            this.setPacketType(annotation.packetType());
            this.setEndpointType(annotation.endpointType());
            this.setServiceBuildPolicy(annotation.serviceBuildPolicy());
            this.setResourceBuildPolicy(annotation.resourceBuildPolicy());
            this.setInitialProviders(Arrays.stream(annotation.initialProviders()).collect(Collectors.toMap(p -> p.name(), p -> p.profileId())));
            this.setObserved(annotation.observed());
        }
    }

    public String getResourceDefinition() {
        if (this.resourceDefinition == null) {
            return this.defaultResourceDefinition;
        }
        return this.resourceDefinition;
    }

    public void setResourceDefinition(String resourceDefinition) {
        this.resourceDefinition = resourceDefinition;
    }

    public SensiNactResourceModelConfiguration.BuildPolicy[] getServiceBuildPolicy() {
        if (this.serviceBuildPolicy == null) {
            return this.defaultServiceBuildPolicy;
        }
        return this.serviceBuildPolicy;
    }

    public void setServiceBuildPolicy(SensiNactResourceModelConfiguration.BuildPolicy[] serviceBuildPolicy) {
        this.serviceBuildPolicy = serviceBuildPolicy;
    }

    public SensiNactResourceModelConfiguration.BuildPolicy[] getResourceBuildPolicy() {
        if (this.resourceBuildPolicy == null) {
            return this.defaultResourceBuildPolicy;
        }
        return this.resourceBuildPolicy;
    }

    public void setResourceBuildPolicy(SensiNactResourceModelConfiguration.BuildPolicy[] resourceBuildPolicy) {
        this.resourceBuildPolicy = resourceBuildPolicy;
    }

    public boolean isStartAtInitializationTime() {
        return this.startAtInitializationTime;
    }

    public void isStartAtInitializationTime(boolean startAtInitializationTime) {
        this.startAtInitializationTime = startAtInitializationTime;
    }

    public Class<? extends Packet> getPacketType() {
        if (this.packetType == null) {
            return this.defaultPacketType;
        }
        return this.packetType;
    }

    public void setPacketType(Class<? extends Packet> packetType) {
        this.packetType = packetType;
    }

    public Class<? extends ProtocolStackEndpoint> getEndpointType() {
        if (this.endpointType == null) {
            return this.defaultEndpointType;
        }
        return this.endpointType;
    }

    public void setEndpointType(Class<? extends ProtocolStackEndpoint> endpointType) {
        this.endpointType = endpointType;
    }

    public Map<String, String> getInitialProviders() {
        if (this.initialProviders == null) {
            return this.defaultInitialProviders;
        }
        return this.initialProviders;
    }

    public void setInitialProviders(Map<String, String> initialProviders) {
        this.initialProviders = initialProviders;
    }

    public String[] getObserved() {
        if (this.observed == null) {
            return this.defaultObserved;
        }
        return this.observed;
    }

    public void setObserved(String[] observed) {
        this.observed = observed;
    }

    public boolean isOutputOnly() {
        return this.outputOnly;
    }

    public void isOutputOnly(boolean outputOnly) {
        this.outputOnly = outputOnly;
    }
}

