/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskCallBack;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.util.JSONUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskImpl
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskImpl.class);
    protected final Object lock = new Object();
    protected final ResourceConfig resourceConfig;
    protected final Object[] parameters;
    protected final TaskTranslator transmitter;
    protected final String path;
    protected final String profileId;
    protected String taskIdentifier;
    protected Object result;
    protected long launched;
    protected long executed;
    protected long timestamp;
    protected final AtomicBoolean available = new AtomicBoolean(false);
    protected final AtomicLong timeout;
    protected Task.LifecycleStatus status;
    private Deque<TaskCallBack> callbacks;
    protected Task.CommandType command;

    public TaskImpl(Task.CommandType command, TaskTranslator transmitter, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        this.transmitter = transmitter;
        this.path = path;
        this.profileId = profileId;
        this.resourceConfig = resourceConfig;
        this.parameters = parameters;
        this.command = command;
        String serviceProviderId = null;
        String service = null;
        String resource = null;
        String attribute = null;
        String[] pathElements = UriUtils.getUriElements((String)path);
        switch (pathElements.length) {
            case 4: {
                attribute = pathElements[3];
            }
            case 3: {
                resource = pathElements[2];
            }
            case 2: {
                service = pathElements[1];
            }
            case 1: {
                serviceProviderId = pathElements[0];
            }
        }
        this.timeout = new AtomicLong(5000L);
        this.status = Task.LifecycleStatus.INITIALIZED;
        this.callbacks = new LinkedList<TaskCallBack>();
        if (serviceProviderId != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(serviceProviderId);
            buffer.append('#');
            buffer.append(this.getCommand().name());
            if (service != null) {
                buffer.append('#');
                buffer.append(service);
            }
            if (resource != null) {
                buffer.append('#');
                buffer.append(resource);
            }
            if (attribute != null) {
                buffer.append('#');
                buffer.append(attribute);
            }
            this.setTaskIdentifier(buffer.toString());
        }
    }

    @Override
    public Task.CommandType getCommand() {
        return this.command;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getProfile() {
        return this.profileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task.LifecycleStatus getLifecycleStatus() {
        Task.LifecycleStatus status = null;
        Task.LifecycleStatus lifecycleStatus = this.status;
        synchronized (lifecycleStatus) {
            status = this.status;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Task status " + (Object)((Object)status) + "[" + System.currentTimeMillis() + "]");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLifecycleStatus(Task.LifecycleStatus status) {
        Task.LifecycleStatus lifecycleStatus = this.status;
        synchronized (lifecycleStatus) {
            this.status = status;
        }
    }

    @Override
    public void setTaskIdentifier(String taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    @Override
    public String getTaskIdentifier() {
        return this.taskIdentifier;
    }

    @Override
    public void setResult(Object result) {
        this.setResult(result, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResult(Object result, long timestamp) {
        if (this.isResultAvailable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("result already set [" + this + "][current: " + (this.result == AccessMethod.EMPTY ? "EMPTY" : this.result) + "][new = " + (result == AccessMethod.EMPTY ? "EMPTY" : result + "]"));
            }
            return;
        }
        this.result = result;
        this.timestamp = timestamp;
        this.setLifecycleStatus(Task.LifecycleStatus.EXECUTED);
        this.executed = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.available.set(true);
        }
        while (!this.callbacks.isEmpty()) {
            this.callbacks.pop().callback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Object result) {
        this.result = result;
        this.setLifecycleStatus(Task.LifecycleStatus.ABORDED);
        this.executed = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.available.set(true);
        }
        while (!this.callbacks.isEmpty()) {
            this.callbacks.pop().callback(this);
        }
    }

    @Override
    public Object getResult() {
        if (!this.isResultAvailable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("result is not available");
            }
            return null;
        }
        return this.result;
    }

    @Override
    public long getTimestamp() {
        if (!this.isResultAvailable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("result is not available");
            }
            return -1L;
        }
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResultAvailable() {
        boolean available;
        Object object = this.lock;
        synchronized (object) {
            available = this.available.get();
        }
        return available;
    }

    public long getExecutionDelay() {
        if (this.getLifecycleStatus() != Task.LifecycleStatus.EXECUTED) {
            return -1L;
        }
        return this.executed - this.launched;
    }

    @Override
    public long getTimeout() {
        return this.timeout.longValue();
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout.set(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCallBack(TaskCallBack callback) {
        if (callback == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.available.get()) {
                callback.callback(this);
            } else {
                this.callbacks.offer(callback);
            }
        }
    }

    @Override
    public void execute() {
        this.setLifecycleStatus(Task.LifecycleStatus.LAUNCHED);
        this.launched = System.currentTimeMillis();
        this.transmitter.send(this);
    }

    public String getJSON() {
        if (!this.isResultAvailable()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("uri");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.path);
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("task");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getCommand().name());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("start");
        builder.append('\"');
        builder.append(':');
        builder.append(this.launched);
        builder.append(',');
        builder.append('\"');
        builder.append("end");
        builder.append('\"');
        builder.append(':');
        builder.append(this.executed);
        builder.append(',');
        builder.append('\"');
        builder.append("status");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.status.name());
        builder.append('\"');
        if (!Task.LifecycleStatus.ABORDED.equals((Object)this.status)) {
            builder.append(',');
            builder.append('\"');
            builder.append("result");
            builder.append('\"');
            builder.append(':');
            builder.append(JSONUtils.toJSONFormat((Object)this.result));
        }
        builder.append('}');
        return builder.toString();
    }
}

