/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.eclipse.sensinact.gateway.generic.packet.PayloadServiceFragment;
import org.eclipse.sensinact.gateway.generic.packet.TaskIdValuePair;

public class PayloadFragmentImpl
implements PayloadFragment {
    protected List<PayloadServiceFragment> payloadFragments = new ArrayList<PayloadServiceFragment>();
    protected boolean isHelloMessage;
    protected boolean isGoodbyeMessage;
    protected String serviceProviderIdentifier;
    protected String profileId;

    public PayloadFragmentImpl() {
    }

    public PayloadFragmentImpl(List<PayloadServiceFragment> payloadFragments) {
        this();
        if (payloadFragments != null) {
            Iterator<PayloadServiceFragment> iterator = payloadFragments.iterator();
            while (iterator.hasNext()) {
                this.addPayloadFragment(iterator.next());
            }
        }
    }

    public void addPayloadFragment(PayloadServiceFragment payloadFragment) {
        if (payloadFragment != null) {
            this.payloadFragments.add(payloadFragment);
        }
    }

    public Iterator<PayloadServiceFragment> iterator() {
        return this.payloadFragments.iterator();
    }

    @Override
    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getServiceProviderIdentifier() {
        return this.serviceProviderIdentifier;
    }

    public void setServiceProviderIdentifier(String serviceProviderIdentifier) {
        this.serviceProviderIdentifier = serviceProviderIdentifier;
    }

    @Override
    public boolean isHelloMessage() {
        return this.isHelloMessage;
    }

    public void isHelloMessage(boolean isHelloMessage) {
        this.isHelloMessage = isHelloMessage;
    }

    @Override
    public boolean isGoodByeMessage() {
        return this.isGoodbyeMessage;
    }

    public void isGoodbyeMessage(boolean isGoodbyeMessage) {
        this.isGoodbyeMessage = isGoodbyeMessage;
    }

    @Override
    public List<TaskIdValuePair> getTaskIdValuePairs() {
        int length;
        ArrayList<TaskIdValuePair> list = new ArrayList<TaskIdValuePair>();
        int n = length = this.payloadFragments == null ? 0 : this.payloadFragments.size();
        for (int index = 0; index < length; ++index) {
            List<TaskIdValuePair> taskIdValuePairs = this.payloadFragments.get(index).AsTaskIdValuePair(this.getServiceProviderIdentifier());
            if (taskIdValuePairs == null || taskIdValuePairs.isEmpty()) continue;
            list.addAll(taskIdValuePairs);
        }
        return list;
    }

    @Override
    public boolean treated(String taskIdentifier) {
        int length;
        boolean treated = false;
        int n = length = this.payloadFragments == null ? 0 : this.payloadFragments.size();
        for (int index = 0; index < length; ++index) {
            treated = this.payloadFragments.get(index).treated(taskIdentifier);
            if (!treated) continue;
            if (this.payloadFragments.get(index).size() != 0) break;
            this.payloadFragments.remove(index);
            break;
        }
        return treated;
    }

    @Override
    public int size() {
        return this.payloadFragments.size();
    }

    public String getName() {
        return this.getServiceProviderIdentifier();
    }
}

