/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.packet;

import java.util.List;
import org.eclipse.sensinact.gateway.generic.packet.annotation.AttributeID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Data;
import org.eclipse.sensinact.gateway.generic.packet.annotation.HelloMessage;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Iteration;
import org.eclipse.sensinact.gateway.generic.packet.annotation.MetadataID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ResourceID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ServiceID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ServiceProviderID;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttPacket;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnSubPacket;

public class TtnUplinkPacket
extends MqttPacket {
    @ServiceProviderID
    private String device;
    @HelloMessage
    private static final boolean HELLO_MESSAGE = false;
    private final List<TtnSubPacket<?>> subPackets;
    private int index = -1;

    public TtnUplinkPacket(String device, List<TtnSubPacket<?>> subPackets) {
        super(device);
        this.device = device;
        this.subPackets = subPackets;
    }

    @Iteration
    public boolean isLast() {
        return ++this.index == this.subPackets.size() - 1;
    }

    @ServiceID
    public String getService() {
        return this.subPackets.get(this.index).getService();
    }

    @ResourceID
    public String getResource() {
        return this.subPackets.get(this.index).getResource();
    }

    @AttributeID
    public String getAttribute() {
        return this.subPackets.get(this.index).getAttribute();
    }

    @MetadataID
    public String getMetadata() {
        return this.subPackets.get(this.index).getMetadata();
    }

    @Data
    public Object getData() {
        return this.subPackets.get(this.index).getValue();
    }
}

