/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.util.CryptoUtils;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicUtils.class);

    public CryptographicUtils() throws NoSuchAlgorithmException {
        Security.addProvider(new BouncyCastleProvider());
    }

    private boolean checkHashValue(String realHash, String pretendedHash) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pretended hash:" + pretendedHash);
        }
        boolean validated = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("real Hash Value:" + realHash);
        }
        if (realHash.equals(pretendedHash)) {
            validated = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("hash valid? " + validated);
        }
        return validated;
    }

    public boolean checkHashValue(Mediator mediator, URL entry, String hashValue, String algo) throws IOException, NoSuchAlgorithmException {
        String realHash = this.getHashValue(mediator, entry.openStream(), algo);
        boolean checked = this.checkHashValue(realHash, hashValue);
        return checked;
    }

    public String getHashValue(Mediator mediator, InputStream iStream, String algo) throws IOException, NoSuchAlgorithmException {
        byte[] fileData = IOUtils.read((InputStream)iStream);
        String hash = this.getHashValue(fileData, algo);
        return hash;
    }

    public boolean checkHashValue(byte[] data, String hashValue, String algo) throws NoSuchAlgorithmException {
        boolean validated = false;
        String realHash = this.getHashValue(data, algo);
        if (realHash.equals(hashValue)) {
            validated = true;
        }
        return validated;
    }

    public byte[] digest(byte[] data, String algo) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        messageDigest = CryptoUtils.getDigest((String)algo);
        if (messageDigest != null) {
            return messageDigest.digest(data);
        }
        throw new NoSuchAlgorithmException();
    }

    public String getHashValue(byte[] data, String algo) throws NoSuchAlgorithmException {
        return Base64.getEncoder().encodeToString(this.digest(data, algo));
    }

    public boolean checkCMSDataValidity(byte[] data, byte[] cmsData, String algo) throws Exception {
        boolean verified = false;
        CMSSignedData cmsWithSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), cmsData);
        verified = this.checkCMSDataValidity(cmsWithSignedData, algo);
        return verified;
    }

    protected boolean checkCMSDataValidity(CMSSignedData cmsData, String securityProvider, String algo) throws Exception {
        boolean verified = false;
        Collection<SignerInformation> signers = cmsData.getSignerInfos().getSigners();
        JcaCertStoreBuilder builder = new JcaCertStoreBuilder();
        builder.addCertificates(cmsData.getCertificates());
        builder.addCertificates(cmsData.getCRLs());
        builder.setProvider(securityProvider);
        Iterator<SignerInformation> iter = signers.iterator();
        SignerInformation signerInfo = null;
        while (iter.hasNext()) {
            signerInfo = iter.next();
            verified = verified || this.verify(signerInfo, builder.build(), algo);
        }
        return verified;
    }

    public Certificate getCertificate(SignerInformation signer, CertStore certStore) throws Exception {
        X509CertificateHolderSelector x509CertificateHolderSelector = new X509CertificateHolderSelector(signer.getSID().getSubjectKeyIdentifier());
        X509CertSelector certSelector = new JcaX509CertSelectorConverter().getCertSelector(x509CertificateHolderSelector);
        Collection<? extends Certificate> certCollection = certStore.getCertificates(certSelector);
        Iterator<? extends Certificate> certIt = certCollection.iterator();
        Certificate x509Cert = certIt.next();
        return x509Cert;
    }

    public boolean verify(SignerInformation signer, CertStore certStore, String algo) throws Exception {
        Certificate x509Cert = this.getCertificate(signer, certStore);
        JcaSimpleSignerInfoVerifierBuilder sigVerifBuilder = new JcaSimpleSignerInfoVerifierBuilder();
        SignerInformationVerifier signerInfoVerif = sigVerifBuilder.setProvider("BC").build(x509Cert.getPublicKey());
        boolean rawVerif = signer.verify(signerInfoVerif);
        boolean signerCertRefVerif = this.signingCertificateAttributeVerif(signer, x509Cert, algo);
        return rawVerif && signerCertRefVerif;
    }

    private boolean signingCertificateAttributeVerif(SignerInformation signer, Certificate x509Cert, String algo) throws CertificateException, NoSuchAlgorithmException {
        boolean signerCertRefVerif = true;
        ESSCertID signingCertRef = CryptographicUtils.getSigningCertificateAttribute(signer.getSignedAttributes());
        if (signingCertRef != null) {
            byte[] certHash = this.digest(x509Cert.getEncoded(), algo);
            signerCertRefVerif = Arrays.equals(certHash, signingCertRef.getCertHash());
        } else {
            ESSCertIDv2 signingCertRefV2 = CryptographicUtils.getSigningCertificateV2Attribute(signer.getSignedAttributes());
            if (signingCertRefV2 != null) {
                String hashAlgorithm = signingCertRefV2.getHashAlgorithm().getAlgorithm().getId();
                byte[] certHash = this.digest(x509Cert.getEncoded(), hashAlgorithm);
                signerCertRefVerif = Arrays.equals(certHash, signingCertRefV2.getCertHash());
            }
        }
        return signerCertRefVerif;
    }

    private static ESSCertID getSigningCertificateAttribute(AttributeTable atab) {
        ESSCertID[] signingCerts;
        Attribute attr;
        ESSCertID result = null;
        if (atab != null && (attr = atab.get(PKCSObjectIdentifiers.id_aa_signingCertificate)) != null && (signingCerts = SigningCertificate.getInstance(attr.getAttrValues().getObjectAt(0)).getCerts()) != null && signingCerts.length > 0) {
            result = signingCerts[0];
        }
        return result;
    }

    private static ESSCertIDv2 getSigningCertificateV2Attribute(AttributeTable atab) {
        ESSCertIDv2[] signingCerts;
        Attribute attr;
        ESSCertIDv2 result = null;
        if (atab != null && (attr = atab.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) != null && (signingCerts = SigningCertificateV2.getInstance(attr.getAttrValues().getObjectAt(0)).getCerts()) != null && signingCerts.length > 0) {
            result = signingCerts[0];
        }
        return result;
    }

    public boolean checkCMSDataValidity(CMSSignedData cmsData, String algo) throws Exception {
        return this.checkCMSDataValidity(cmsData, "BC", algo);
    }
}

