/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.signature.internal.CryptographicUtils;
import org.eclipse.sensinact.gateway.security.signature.internal.KeyStoreManager;
import org.eclipse.sensinact.gateway.security.signature.internal.SignatureBlock;
import org.eclipse.sensinact.gateway.security.signature.internal.SignatureFile;
import org.eclipse.sensinact.gateway.security.signature.internal.SignedBundleChecker;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedBundle {
    private static final Logger LOG = LoggerFactory.getLogger(SignedBundle.class);
    private KeyStoreManager ksm = null;
    private final CryptographicUtils cryptoUtils;
    protected static final String METADATA_DIR = "/META-INF/";
    protected static final String MF_FILE = "MANIFEST.MF";
    private Map<String, SignatureFile> signatureFiles = null;
    private Map<String, Certificate> certs = null;
    private Map<String, SignatureBlock> signatureBlocks = null;
    private Bundle bundle;
    private Mediator mediator;

    public SignedBundle(Mediator mediator, Bundle bundle, CryptographicUtils cryptoUtils) throws IOException {
        this.mediator = mediator;
        this.bundle = bundle;
        this.cryptoUtils = cryptoUtils;
    }

    public List<URL> getEntries() {
        ArrayList<URL> listEntries = Collections.list(this.bundle.findEntries("/", "*", true));
        return listEntries;
    }

    public void setKeyStoreManager(KeyStoreManager ksm) {
        this.ksm = ksm;
    }

    public URL getEntry(String path) {
        URL entry = this.bundle.getEntry(path);
        return entry;
    }

    public Manifest getManifest() {
        Manifest manifest = new Manifest();
        try {
            manifest.read(this.getEntry("/META-INF/MANIFEST.MF").openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return manifest;
    }

    private Map<String, SignatureFile> getSignatureFiles() throws IOException {
        if (this.signatureFiles == null) {
            this.signatureFiles = new HashMap<String, SignatureFile>();
            SignatureFile signedFile = null;
            String signerName = "";
            Enumeration entries = this.bundle.findEntries(METADATA_DIR, "*.SF", true);
            URL jEntry = null;
            while (entries.hasMoreElements()) {
                jEntry = (URL)entries.nextElement();
                signedFile = new SignatureFile(this.mediator, jEntry);
                String path = jEntry.getPath();
                int index = path.lastIndexOf(47);
                String signer = path.substring(index + 1, path.lastIndexOf(46));
                this.signatureFiles.put(signer, signedFile);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Better performance, data found (signatureFiles)");
        }
        return this.signatureFiles;
    }

    public SignatureFile getSignatureFile(String givenSigner) throws IOException {
        Map<String, SignatureFile> signatures;
        SignatureFile file;
        String signer = SignedBundle.getSignerShortName(givenSigner);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SignedJarFile.getSignatureFile, signer: " + signer);
        }
        if ((file = (signatures = this.getSignatureFiles()).get(signer)) == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("SignedJarFile.getSignatureFile: signature file not available.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Better performance, data found (signatureFile)");
        }
        return file;
    }

    public Certificate getCertificate(String signer) throws IOException, CMSException, GeneralSecurityException {
        Certificate cert = null;
        if (this.certs == null) {
            this.certs = new HashMap<String, Certificate>();
        }
        if ((cert = this.certs.get(signer)) == null) {
            SignatureBlock block = this.getSignatureBlock(signer);
            SignerInformationStore signers = block.getSignerInfos();
            JcaCertStoreBuilder builder = new JcaCertStoreBuilder();
            builder.addCertificates(block.getCertificates());
            builder.addCRLs(block.getCRLs());
            builder.setProvider("SUN");
            Iterator<SignerInformation> iter = signers.getSigners().iterator();
            if (iter.hasNext()) {
                SignerInformation signerInfo = iter.next();
                try {
                    cert = (X509Certificate)this.cryptoUtils.getCertificate(signerInfo, builder.build());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.certs.put(signer, cert);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Better performance, data found (cert)");
        }
        return cert;
    }

    public byte[] getSignatureFromBlock(String signer) throws IOException, CMSException {
        CMSSignedData pkcs7 = this.getSignatureBlockAsCMS(signer);
        return SignatureBlock.getSignatureFromSignedData(pkcs7);
    }

    public SignatureBlock getSignatureBlock(String signer) throws IOException, CMSException {
        SignatureBlock block = null;
        if (this.signatureBlocks == null) {
            this.signatureBlocks = new HashMap<String, SignatureBlock>();
        } else {
            block = this.signatureBlocks.get(signer);
        }
        if (block == null) {
            block = SignatureBlock.getInstance(this.mediator, this, signer);
            this.signatureBlocks.put(signer, block);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Better performance, data found (block)");
        }
        return block;
    }

    public CMSSignedData getSignatureBlockAsCMS(String signer) throws IOException, CMSException {
        return new CMSSignedData(this.getSignatureBlock(signer).getEncoded());
    }

    public Map<String, Certificate> getCertificates() throws CMSException, IOException, GeneralSecurityException {
        HashMap<String, Certificate> certs = new HashMap<String, Certificate>();
        Set<String> signers = this.getSignatureFiles().keySet();
        Iterator<String> iter = signers.iterator();
        String signer = "";
        Certificate cert = null;
        while (iter.hasNext()) {
            signer = iter.next();
            cert = this.getCertificate(signer);
            certs.put(signer, cert);
        }
        return certs;
    }

    private Map<String, Certificate> extractValidCertificates(String passwd) throws CMSException, IOException, GeneralSecurityException {
        HashMap<String, Certificate> validCertificates = new HashMap<String, Certificate>();
        Map<String, Certificate> certificates = this.getCertificates();
        Iterator<Map.Entry<String, Certificate>> iter = certificates.entrySet().iterator();
        Certificate currentCert = null;
        boolean currentCertificateValid = false;
        String signer = "";
        while (iter.hasNext()) {
            Map.Entry<String, Certificate> entry = iter.next();
            signer = entry.getKey();
            currentCert = certificates.get(signer);
            currentCertificateValid = this.isCertValid(currentCert, passwd);
            if (!currentCertificateValid) continue;
            validCertificates.put(signer, (X509Certificate)currentCert);
        }
        return validCertificates;
    }

    private boolean isCertValid(Certificate currentCert, String passwd) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        boolean certificateValid = false;
        if (this.ksm != null) {
            certificateValid = passwd == null ? this.ksm.isTemporallyOK(currentCert) : this.ksm.isValid(currentCert);
        }
        return certificateValid;
    }

    public Map<String, Certificate> getValidCertificates(String passwd) throws IOException, CMSException, GeneralSecurityException {
        Map<Object, Object> validCertificates = null;
        validCertificates = "".equals(passwd) ? new HashMap() : this.extractValidCertificates(passwd);
        return validCertificates;
    }

    public boolean checkCoherence(String signer, Certificate cert, String algo) throws Exception {
        return new SignedBundleChecker(this.mediator).checkCoherence(this, signer, cert, this.cryptoUtils, algo);
    }

    public static String getSignerShortName(String givenSigner) {
        String signer = "";
        signer = givenSigner.length() > 8 ? givenSigner.substring(0, 8) : givenSigner;
        return signer;
    }
}

