/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.checker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.exception.InvalidApplicationException;
import org.eclipse.sensinact.gateway.app.manager.json.AppComponent;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;

public class ArchitectureChecker {
    public static void checkApplication(String applicationName, List<AppComponent> components) throws InvalidApplicationException {
        List<String> identifiers = ArchitectureChecker.checkUniqueOutput(applicationName, components);
        ArchitectureChecker.checkVariableExist(components, identifiers);
    }

    private static List<String> checkUniqueOutput(String applicationName, List<AppComponent> components) throws InvalidApplicationException {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (AppComponent component : components) {
            String uri = "/" + applicationName + "/" + component.getIdentifier() + "/" + "result";
            if (!identifiers.contains(uri)) {
                identifiers.add(uri);
                continue;
            }
            throw new InvalidApplicationException("The variable " + uri + " already exists.");
        }
        return identifiers;
    }

    private static void checkVariableExist(List<AppComponent> components, List<String> identifiers) throws InvalidApplicationException {
        for (AppComponent component : components) {
            for (AppParameter parameter : component.getFunction().getRunParameters()) {
                if (!parameter.getType().equals("variable") || identifiers.contains(parameter.getValue())) continue;
                throw new InvalidApplicationException("The variable " + parameter.getValue() + " does not exist.");
            }
        }
    }
}

