/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.logging.Level;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintOnComparable;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;

public class MaxExclusive<T>
extends ConstraintOnComparable<T> {
    public static final String OPERATOR = "<";

    public MaxExclusive(Class<T> operandClass, Object operand, boolean complement) throws InvalidConstraintDefinitionException {
        super(OPERATOR, operandClass, operand, complement);
    }

    @Override
    public boolean doComplies(T castedValue) {
        return this.operand.compareTo(castedValue) > 0 ^ this.isComplement();
    }

    @Override
    public Constraint getComplement() {
        MaxExclusive complement = null;
        try {
            complement = new MaxExclusive(this.operand.getClass(), this.operand, !this.complement);
        }
        catch (InvalidConstraintDefinitionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return complement;
    }
}

