/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.primitive;

import org.eclipse.sensinact.gateway.common.primitive.Description;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.Primitive;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class PrimitiveDescription
implements Description,
Nameable {
    protected static final int INDENT_FACTOR = 3;
    protected static final String URI_KEY = "uri";
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String VALUE_KEY = "value";
    protected final String TIMESTAMP_KEY = "timestamp";
    protected final String name;
    protected final Class<?> type;
    protected Object value;
    protected final Modifiable modifiable;

    protected PrimitiveDescription(String name, Class<?> type, Modifiable modifiable) {
        this.name = name;
        this.type = type;
        this.modifiable = modifiable;
    }

    protected <P extends Primitive> PrimitiveDescription(P primitive) {
        this.name = primitive.getName();
        this.type = primitive.getType();
        this.modifiable = primitive.getModifiable();
        this.value = primitive.getValue();
    }

    @Override
    public String getJSON() {
        JSONObject description = this.getJSONObject();
        description.put(VALUE_KEY, PrimitiveDescription.toJson(this.getType(), this.getValue()));
        return description.toString(3);
    }

    protected final JSONObject getJSONObject() {
        JSONObject description = new JSONObject();
        description.put(NAME_KEY, (Object)this.name);
        String typeName = CastUtils.writeClass(this.getType());
        description.put(TYPE_KEY, (Object)typeName);
        return description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Modifiable getModifiable() {
        return this.modifiable;
    }

    protected void update(Object object) {
        this.value = object;
    }

    public static Object toJson(Class<?> type, Object value) {
        if (value == null) {
            return JSONObject.NULL;
        }
        if (String.class == type || type.isPrimitive() || JSONObject.class.isAssignableFrom(type) || JSONArray.class.isAssignableFrom(type)) {
            return value;
        }
        if (type.isEnum()) {
            return ((Enum)value).name();
        }
        return JSONUtils.toJSONFormat((Object)value);
    }
}

