/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.subscriptions;

import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.spi.ISessionsStore;
import java.io.Serializable;

public final class Subscription
implements Serializable {
    final AbstractMessage.QOSType requestedQos;
    final String clientId;
    final String topicFilter;
    final boolean active;

    public Subscription(String clientId, String topicFilter, AbstractMessage.QOSType requestedQos) {
        this.requestedQos = requestedQos;
        this.clientId = clientId;
        this.topicFilter = topicFilter;
        this.active = true;
    }

    public Subscription(Subscription orig) {
        this.requestedQos = orig.requestedQos;
        this.clientId = orig.clientId;
        this.topicFilter = orig.topicFilter;
        this.active = orig.active;
    }

    public String getClientId() {
        return this.clientId;
    }

    public AbstractMessage.QOSType getRequestedQos() {
        return this.requestedQos;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        return !(this.topicFilter == null ? that.topicFilter != null : !this.topicFilter.equals(that.topicFilter));
    }

    public int hashCode() {
        int result = this.clientId != null ? this.clientId.hashCode() : 0;
        result = 31 * result + (this.topicFilter != null ? this.topicFilter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("[filter:%s, cliID: %s, qos: %s, active: %s]", new Object[]{this.topicFilter, this.clientId, this.requestedQos, this.active});
    }

    public Subscription clone() {
        try {
            return (Subscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public ISessionsStore.ClientTopicCouple asClientTopicCouple() {
        return new ISessionsStore.ClientTopicCouple(this.clientId, this.topicFilter);
    }
}

