/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sensinact.gateway.util.rest.RestLikeMapperException;
import org.eclipse.sensinact.gateway.util.rest.RestLikeMappingReport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RestLikeMapper {
    private static final char AND = '&';
    private static final char EQUALITY = '=';
    private static final char LESS = '-';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final String SEPARATOR_CHAR = "/";
    private static final String PLURAL_SUFFIX = "s";
    private static final String OBJECTCLASS = "objectClass";
    private static final String VARIABLE = "#VARIABLE#";
    private BundleContext context;
    private String[][] filters;
    private String[][] hierarchies;
    private List<String> methods;

    public RestLikeMapper(BundleContext context, String[][] filters, String[][] hierarchies, String[] methods) throws RestLikeMapperException {
        if (filters == null || filters.length == 0 || filters[0].length != 3) {
            throw new RestLikeMapperException("Invalid initial configuration map");
        }
        this.context = context;
        this.filters = new String[2 * filters.length][2];
        this.hierarchies = new String[2 * hierarchies.length][2];
        int pos = 0;
        for (int index = 0; index < filters.length; ++index) {
            String[] mapping = filters[index];
            this.filters[pos][0] = this.plural(mapping[0]);
            this.filters[pos++][1] = mapping[2] == null ? null : '(' + OBJECTCLASS + '=' + mapping[2] + ')';
            this.filters[pos][0] = mapping[0];
            this.filters[pos++][1] = mapping[1] == null ? null : '(' + mapping[1] + '=' + VARIABLE + ')';
        }
        List<Object> list = this.methods = methods != null ? Arrays.asList(methods) : Collections.emptyList();
        if (hierarchies == null || hierarchies.length == 0 || hierarchies[0].length != 4) {
            return;
        }
        pos = 0;
        for (String[] hierarchy : hierarchies) {
            if (hierarchy[0] == null || hierarchy[1] == null) continue;
            if (hierarchy[2] != null) {
                this.hierarchies[pos][0] = hierarchy[0] + '-' + hierarchy[1];
                this.hierarchies[pos++][1] = '(' + (hierarchy[2].length() == 0 ? this.plural(hierarchy[1]) : hierarchy[2]) + '=' + VARIABLE + ')';
            }
            if (hierarchy[3] == null) continue;
            this.hierarchies[pos][0] = hierarchy[1] + '-' + hierarchy[0];
            this.hierarchies[pos++][1] = '(' + (hierarchy[3].length() == 0 ? this.plural(hierarchy[0]) : hierarchy[3]) + '=' + VARIABLE + ')';
        }
        this.hierarchies = (String[][])Arrays.copyOfRange(this.hierarchies, 0, pos);
    }

    private String plural(String singular) {
        return singular + PLURAL_SUFFIX;
    }

    private String concat(String filterFst, String filterSnd) {
        if (filterFst == null) {
            return filterSnd;
        }
        if (filterSnd == null) {
            return filterFst;
        }
        return "" + '(' + '&' + (filterFst.charAt(0) == '(' ? "" : Character.valueOf('(')) + filterFst + (filterFst.charAt(filterFst.length() - 1) == ')' ? "" : Character.valueOf(')')) + (filterSnd.charAt(0) == '(' ? "" : Character.valueOf('(')) + filterSnd + (filterSnd.charAt(filterSnd.length() - 1) == ')' ? "" : Character.valueOf(')')) + ')';
    }

    public RestLikeMappingReport parseURI(String uri) {
        String[] uriElements = uri.trim().split(SEPARATOR_CHAR);
        if (uri.startsWith(SEPARATOR_CHAR)) {
            uriElements = Arrays.copyOfRange(uriElements, 1, uriElements.length);
        }
        RestLikeMappingReport report = new RestLikeMappingReport(uriElements);
        if (this.methods.contains(uriElements[uriElements.length - 1])) {
            report.reportMethod(uriElements[uriElements.length - 1]);
            uriElements = Arrays.copyOf(uriElements, uriElements.length - 1);
        }
        LinkedList<String> fstack = new LinkedList<String>();
        int last = -1;
        String variable = null;
        for (int i = 0; i < uriElements.length; i += 2) {
            int k;
            int j;
            String plural = uriElements[i];
            String singular = i < uriElements.length - 1 ? uriElements[i + 1] : null;
            for (j = 0; j < this.filters.length && !this.filters[j][0].equals(plural); j += 2) {
            }
            if (j == this.filters.length) break;
            String filter = this.concat(this.filters[j][1], this.filters[j + 1][1] != null && singular != null ? this.filters[j + 1][1].replace(VARIABLE, singular) : null);
            if (last == -1) {
                if (filter != null) {
                    fstack.offer(filter);
                    report.reportFilter(singular != null ? i + 1 : i, filter);
                }
                last = j;
                variable = singular;
                continue;
            }
            if (filter != null) {
                report.reportIndex(this.filters[j + 1][1] != null ? i + 2 : i + 1);
                report.reportImplementation(this.filters[j][1] != null ? this.filters[j][1].substring(new StringBuilder().append('(').append(OBJECTCLASS).append('=').length(), this.filters[j][1].length() - 1) : null);
            }
            for (k = 0; k < this.hierarchies.length; ++k) {
                String descendant = this.filters[last + 1][0] + '-' + this.filters[j + 1][0];
                String ascendant = this.filters[j + 1][0] + '-' + this.filters[last + 1][0];
                String tmpFilter = null;
                if (this.hierarchies[k][0].equals(descendant)) {
                    tmpFilter = this.concat((String)fstack.pollLast(), this.hierarchies[k][1].replace(VARIABLE, singular));
                    fstack.offer(tmpFilter);
                    report.reportFilter(i - 1, tmpFilter);
                    if (filter == null || singular == null) break;
                    fstack.offer(filter);
                    break;
                }
                if (!this.hierarchies[k][0].equals(ascendant)) continue;
                fstack.pollLast();
                report.reportFilter(i - 1, null);
                tmpFilter = this.concat(filter, this.hierarchies[k][1].replace(VARIABLE, variable));
                fstack.offer(tmpFilter);
                report.reportFilter(i, tmpFilter);
                if (filter == null || singular == null) break;
                fstack.offer(filter);
                break;
            }
            if (k == this.hierarchies.length) break;
            last = j;
            variable = singular;
        }
        List services = Collections.emptyList();
        while (!fstack.isEmpty()) {
            String filter = (String)fstack.pop();
            try {
                ServiceReference[] current = this.context.getServiceReferences((String)null, filter);
                if (current == null) break;
                LinkedList srs = new LinkedList(Arrays.asList(current));
                LinkedList<ServiceReference> intersection = null;
                LinkedList<ServiceReference> references = null;
                if (services.size() == 0) {
                    services = srs;
                    report.reportReferences(filter, srs);
                    continue;
                }
                ServiceReference[] copy = new ServiceReference[current.length];
                System.arraycopy(current, 0, copy, 0, current.length);
                references = new LinkedList<ServiceReference>(Arrays.asList(copy));
                references.removeAll(services);
                intersection = new LinkedList<ServiceReference>(Arrays.asList(current));
                intersection.removeAll(references);
                List<Object> list = services = intersection.size() == 0 ? srs : intersection;
                if (services.size() == 0) break;
                report.reportReferences(filter, intersection.size() == 0 ? srs : intersection);
            }
            catch (InvalidSyntaxException e) {
                report.reportError(new RestLikeMapperException(e.getMessage() + " : " + filter, e));
            }
        }
        return report;
    }
}

