/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import org.eclipse.sensinact.gateway.core.security.dao.AbstractSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Immutable;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMutableSnaDAO<E extends SnaEntity>
extends AbstractSnaDAO<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMutableSnaDAO.class);

    AbstractMutableSnaDAO(Class<E> entityType, DataStoreService dataStoreService) throws DAOException {
        super(entityType, dataStoreService);
        if (this.entityType.getAnnotation(Immutable.class) != null) {
            throw new DAOException("Mutable type expected");
        }
    }

    @Override
    void created(E entity, long identifier) {
        if (entity == null || identifier < 0L) {
            return;
        }
        if (SnaEntity.setUniqueLongPrimaryKey(entity, identifier)) {
            LOG.debug("new %s record in the datastore", (Object)this.entityType.getSimpleName());
        } else {
            LOG.debug("Unable to define the new entity '%s' identifier [%s]", (Object)this.entityType.getSimpleName(), (Object)identifier);
        }
    }

    @Override
    void updated(int records) {
        LOG.debug("%s %s record(s) updated in the datastore", (Object)records, (Object)this.entityType.getSimpleName());
    }

    @Override
    void deleted(int records) {
        LOG.debug("%s %s record(s) deleted in the datastore", (Object)records, (Object)this.entityType.getSimpleName());
    }
}

