/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.ssdp.discovery;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Enumeration;
import org.eclipse.sensinact.gateway.protocol.ssdp.discovery.SSDPAbstractListenerThread;
import org.eclipse.sensinact.gateway.protocol.ssdp.exception.InvalidParameterException;
import org.eclipse.sensinact.gateway.protocol.ssdp.listener.SSDPDiscoveryNotifier;
import org.eclipse.sensinact.gateway.protocol.ssdp.model.MSearchMessage;
import org.eclipse.sensinact.gateway.protocol.ssdp.parser.SSDPDiscoveryParser;

public class SSDPDiscoveryListenerThread
extends SSDPAbstractListenerThread {
    private DatagramChannel channel;
    private Thread thread;

    public SSDPDiscoveryListenerThread(SSDPDiscoveryNotifier notifier, NetworkInterface networkInterface) {
        super(notifier, networkInterface);
        try {
            InetAddress addr = null;
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address instanceof Inet6Address) continue;
                addr = address;
                break;
            }
            this.channel = DatagramChannel.open();
            this.channel.socket().bind(new InetSocketAddress(addr, 9654));
            this.sendDiscovery();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        ByteBuffer in = ByteBuffer.allocate(8000);
        while (this.running) {
            try {
                in.clear();
                if (!this.channel.isOpen()) break;
                this.channel.receive(in);
                in.flip();
                byte[] buf = new byte[in.limit()];
                in.get(buf, 0, in.limit());
                this.notifier.newSSDPPacket(SSDPDiscoveryParser.parse(new String(buf)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        this.running = false;
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendDiscovery() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8000);
        try {
            buffer.put(MSearchMessage.createMessage("upnp:rootdevice", 3).getBytes());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
        }
        buffer.flip();
        this.channel.send(buffer, new InetSocketAddress("239.255.255.250", 1900));
    }
}

