/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Primitive;
import org.eclipse.sensinact.gateway.common.primitive.PrimitiveDescription;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.MetadataDescription;
import org.json.JSONArray;
import org.json.JSONObject;

public class AttributeDescription
extends PrimitiveDescription {
    private static final String EMPTY = "";
    private static final String METADATA_KEY = "metadata";
    private final boolean hidden;
    private final MetadataDescription[] metadataDescriptions;

    public AttributeDescription(Attribute attribute, MetadataDescription[] descriptions) {
        super((Primitive)attribute);
        this.hidden = attribute.isHidden();
        this.metadataDescriptions = descriptions;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getJSON() {
        if (this.isHidden()) {
            return EMPTY;
        }
        JSONObject description = super.getJSONObject();
        description.put("value", AttributeDescription.toJson((Class)this.getType(), (Object)this.getValue()));
        for (MetadataDescription metadataDescription : this.metadataDescriptions) {
            if (!("locked".equals(metadataDescription.getName()) || "hidden".equals(metadataDescription.getName()) || "nickname".equals(metadataDescription.getName()) || Modifiable.FIXED.equals((Object)metadataDescription.getModifiable()))) {
                description.put(metadataDescription.getName(), AttributeDescription.toJson((Class)metadataDescription.getType(), (Object)metadataDescription.getValue()));
            }
            if (!"nickname".equals(metadataDescription.getName())) continue;
            description.put("name", metadataDescription.getValue());
        }
        return description.toString();
    }

    public String getJSONDescription() {
        JSONObject description = this.getJSONObjectDescription();
        if (description == null) {
            return EMPTY;
        }
        return description.toString(3);
    }

    protected JSONObject getJSONObjectDescription() {
        if (this.isHidden()) {
            return null;
        }
        JSONObject description = super.getJSONObject();
        if (Modifiable.FIXED.equals((Object)this.getModifiable())) {
            description.put("value", AttributeDescription.toJson((Class)this.getType(), (Object)this.getValue()));
        }
        JSONArray metadataJSON = new JSONArray();
        for (MetadataDescription metadataDescription : this.metadataDescriptions) {
            JSONObject metadataDescriptionJSON;
            if ("locked".equals(metadataDescription.getName()) || "hidden".equals(metadataDescription.getName()) || (metadataDescriptionJSON = metadataDescription.getJSONObjectDescription()) == null) continue;
            metadataJSON.put((Object)metadataDescriptionJSON);
        }
        description.put(METADATA_KEY, (Object)metadataJSON);
        return description;
    }
}

