/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.primitive.Typable;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.LocationResource;
import org.eclipse.sensinact.gateway.core.PropertyResource;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.SensorDataResource;
import org.eclipse.sensinact.gateway.core.StateVariableResource;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class TypeConfig
implements Typable<Type> {
    private static final Class<? extends ResourceImpl> DEFAULT_IMPLEMENTATION_CLASS = ResourceImpl.class;
    protected final Type type;
    protected Class<? extends Resource> implementationInterface;
    private Class<? extends ResourceImpl> baseClass;
    private Class<? extends ResourceImpl> implementationClass;
    protected LinkedList<Class<Resource>> list;
    private AttributeBuilder[] attributeBuilders;

    public TypeConfig(Class<? extends Resource> implementationInterface) {
        this.implementationInterface = implementationInterface;
        this.list = ReflectUtils.getOrderedImplementedInterfaces(Resource.class, implementationInterface);
        Resource.Type type = (Resource.Type)((Object)this.getConstantValue("TYPE_VALUE", true));
        String typeName = type.name();
        this.type = type == Resource.Type.PROPERTY && LocationResource.class.isAssignableFrom(implementationInterface) ? Type.LOCATION : Type.valueOf(typeName);
    }

    public TypeConfig(Type type) {
        this.type = type;
        switch (type) {
            case ACTION: {
                this.implementationInterface = ActionResource.class;
                break;
            }
            case LOCATION: {
                this.implementationInterface = LocationResource.class;
                break;
            }
            case PROPERTY: {
                this.implementationInterface = PropertyResource.class;
                break;
            }
            case SENSOR: {
                this.implementationInterface = SensorDataResource.class;
                break;
            }
            case STATE_VARIABLE: {
                this.implementationInterface = StateVariableResource.class;
                break;
            }
            default: {
                this.implementationInterface = null;
            }
        }
        this.list = ReflectUtils.getOrderedImplementedInterfaces(Resource.class, this.implementationInterface);
    }

    public Type getType() {
        return this.type;
    }

    public Resource.Type getResourceType() {
        return this.type.getResourceType();
    }

    public Class<? extends ResourceImpl> getResourceBaseClass() {
        if (this.baseClass == null) {
            return this.getDefaultImplementationClass();
        }
        return this.baseClass;
    }

    public void setBaseClass(Class<? extends ResourceImpl> baseClass) {
        this.baseClass = baseClass;
    }

    public Class<? extends ResourceImpl> getResourceImplementedClass() {
        if (this.implementationClass == null) {
            return this.getDefaultImplementationClass();
        }
        return this.implementationClass;
    }

    public Class<? extends Resource> getResourceImplementedInterface() {
        return this.implementationInterface;
    }

    public void setResourceImplementedInterface(Class<? extends Resource> implementedInterface) {
        if (implementedInterface == null) {
            return;
        }
        switch (this.type) {
            case ACTION: {
                if (ActionResource.class.isAssignableFrom(implementedInterface)) break;
                return;
            }
            case LOCATION: {
                if (LocationResource.class.isAssignableFrom(implementedInterface)) break;
                return;
            }
            case PROPERTY: {
                if (PropertyResource.class.isAssignableFrom(implementedInterface)) break;
                return;
            }
            case SENSOR: {
                if (SensorDataResource.class.isAssignableFrom(implementedInterface)) break;
                return;
            }
            case STATE_VARIABLE: {
                if (StateVariableResource.class.isAssignableFrom(implementedInterface)) break;
                return;
            }
        }
        this.implementationInterface = implementedInterface;
        this.list = ReflectUtils.getOrderedImplementedInterfaces(Resource.class, this.implementationInterface);
    }

    public void setImplementationClass(Class<? extends ResourceImpl> implementationClass) {
        this.implementationClass = implementationClass;
    }

    protected Class<? extends ResourceImpl> getDefaultImplementationClass() {
        return DEFAULT_IMPLEMENTATION_CLASS;
    }

    public <T> T getConstantValue(String constant, boolean fromTop) {
        return (T)ReflectUtils.getConstantValue(this.list, (String)constant, (boolean)fromTop);
    }

    protected List<AttributeBuilder> getAttributeBuilders() {
        if (this.attributeBuilders == null) {
            this.attributeBuilders = AttributeBuilder.getAttributeBuilders(this.list);
        }
        return Arrays.asList(AttributeBuilder.clone(this.attributeBuilders, this.attributeBuilders.length));
    }

    public static enum Type {
        STATE_VARIABLE(Resource.Type.STATE_VARIABLE),
        SENSOR(Resource.Type.SENSOR),
        PROPERTY(Resource.Type.PROPERTY),
        LOCATION(Resource.Type.PROPERTY),
        ACTION(Resource.Type.ACTION);

        private final Resource.Type type;

        private Type(Resource.Type type) {
            this.type = type;
        }

        Resource.Type getResourceType() {
            return this.type;
        }
    }
}

