/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Changed;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.Expression;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.common.props.TypedProperties;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnaFilter
implements JSONable {
    private static final Logger LOG = LoggerFactory.getLogger(SnaFilter.class);
    protected List<SnaMessage.Type> handledTypes;
    protected final List<Constraint> conditions;
    protected final String sender;
    protected final Pattern pattern;
    protected final boolean isPattern;
    protected final boolean isComplement;
    protected Changed changed;
    protected final Mediator mediator;

    public SnaFilter(Mediator mediator, String sender) {
        this(mediator, sender, false, false);
    }

    public SnaFilter(Mediator mediator, String sender, boolean isPattern, boolean isComplement) {
        this.mediator = mediator;
        this.sender = sender;
        this.conditions = new ArrayList<Constraint>();
        this.handledTypes = new ArrayList<SnaMessage.Type>();
        this.isPattern = isPattern;
        this.isComplement = isComplement;
        Pattern pattern = null;
        if (this.isPattern) {
            try {
                pattern = Pattern.compile(sender);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
            }
        }
        this.pattern = pattern;
    }

    public SnaFilter(Mediator mediator, String sender, JSONArray constraints) {
        this(mediator, sender, false, false, constraints);
    }

    public SnaFilter(Mediator mediator, String sender, boolean isPattern, boolean isComplement, JSONArray constraints) {
        this(mediator, sender, isPattern, isComplement);
        int length;
        int n = length = constraints == null ? 0 : constraints.length();
        for (int index = 0; index < length; ++index) {
            this.addCondition(constraints.getJSONObject(index));
        }
    }

    public String getSender() {
        return this.sender;
    }

    public void addCondition(JSONObject jsonCondition) {
        try {
            this.addCondition(ConstraintFactory.Loader.load((ClassLoader)this.mediator.getClassLoader(), (JSONObject)jsonCondition));
        }
        catch (ClassCastException e) {
            LOG.debug(e.getMessage());
        }
        catch (InvalidConstraintDefinitionException e) {
            LOG.debug(e.getMessage());
        }
    }

    public void addCondition(Constraint condition) {
        if (condition == null) {
            return;
        }
        if (Changed.class.isAssignableFrom(condition.getClass())) {
            this.changed = (Changed)condition;
        } else if (Expression.class.isAssignableFrom(condition.getClass())) {
            ListIterator iterator = ((Expression)condition).listIterator();
            while (iterator.hasNext()) {
                Constraint constraint = (Constraint)iterator.next();
                if (!Changed.class.isAssignableFrom(condition.getClass())) continue;
                this.changed = (Changed)condition;
                iterator.remove();
            }
            if (!this.conditions.isEmpty()) {
                this.conditions.add(condition);
            }
        } else {
            this.conditions.add(condition);
        }
    }

    public void addHandledType(SnaMessage.Type type) {
        if (type == null) {
            return;
        }
        this.handledTypes.add(type);
    }

    public void addHandledType(SnaMessage.Type[] types) {
        int length;
        int n = length = types == null ? 0 : types.length;
        for (int index = 0; index < length; ++index) {
            this.addHandledType(types[index]);
        }
    }

    public boolean matches(SnaMessage<?> message) {
        boolean matchType = this.matchesType(message);
        if (!matchType) {
            return false;
        }
        boolean matchSender = this.matchesSender(message);
        if (!matchSender) {
            return matchSender ^ this.isComplement;
        }
        boolean matchCondition = this.matchesConditions(message);
        if (!matchCondition) {
            return matchCondition ^ this.isComplement;
        }
        return true ^ this.isComplement;
    }

    boolean matchesSender(SnaMessage<?> message) {
        String namespace;
        boolean matchSender = false;
        String uri = message.getPath();
        matchSender = !this.isPattern ? this.sender.equals(uri) : this.pattern.matcher(uri).matches();
        if (!matchSender && (namespace = (String)((AbstractSnaMessage)message).get("namespace")) != null) {
            String[] uriElements = UriUtils.getUriElements((String)uri);
            uriElements[0] = namespace + ":" + uriElements[0];
            String resolvedUri = UriUtils.getUri((String[])uriElements);
            matchSender = !this.isPattern ? this.sender.equals(resolvedUri) : this.pattern.matcher(resolvedUri).matches();
        }
        return matchSender;
    }

    boolean matchesType(SnaMessage<?> message) {
        return this.handledTypes.contains((Object)((SnaMessageSubType)((Object)message.getType())).getSnaMessageType());
    }

    boolean matchesConditions(SnaMessage<?> message) {
        Object toValidate = null;
        block0 : switch (((SnaMessageSubType)((Object)message.getType())).getSnaMessageType()) {
            case ERROR: {
                break;
            }
            case LIFECYCLE: {
                switch ((SnaLifecycleMessage.Lifecycle)message.getType()) {
                    case RESOURCE_APPEARING: {
                        JSONObject initial = new JSONObject(message.getJSON()).optJSONObject("initial");
                        if (JSONObject.NULL.equals(initial)) break block0;
                        toValidate = initial.opt("value");
                        break block0;
                    }
                }
                break;
            }
            case RESPONSE: {
                JSONObject response = new JSONObject(message.getJSON()).optJSONObject("response");
                if (JSONObject.NULL.equals(response)) break;
                toValidate = response.opt("value");
                break;
            }
            case REMOTE: {
                JSONObject remote = new JSONObject(message.getJSON()).optJSONObject("notification");
                if (JSONObject.NULL.equals(remote)) break;
                toValidate = remote.opt("namespace");
                break;
            }
            case UPDATE: {
                switch ((SnaUpdateMessage.Update)message.getType()) {
                    case ACTUATED: {
                        return false;
                    }
                    case ATTRIBUTE_VALUE_UPDATED: 
                    case METADATA_VALUE_UPDATED: {
                        if (this.handleChangedStatus((Boolean)((TypedProperties)message).get("hasChanged"))) {
                            JSONObject notification = new JSONObject(message.getJSON()).optJSONObject("notification");
                            if (JSONObject.NULL.equals(notification)) break block0;
                            toValidate = notification.opt("value");
                            break;
                        }
                        return false;
                    }
                }
                break;
            }
        }
        if (toValidate == null) {
            return true;
        }
        for (int index = 0; index < this.conditions.size(); ++index) {
            if (this.conditions.get(index).complies(toValidate)) continue;
            return false;
        }
        return true;
    }

    private boolean handleChangedStatus(Boolean status) {
        if (this.changed == null) {
            this.changed = new Changed();
        }
        boolean handle = this.changed.complies((Object)status);
        return handle;
    }

    public boolean equals(Object object) {
        if (!SnaFilter.class.isAssignableFrom(object.getClass())) {
            return false;
        }
        SnaFilter snaFilter = (SnaFilter)object;
        if (!snaFilter.sender.equals(this.sender)) {
            return false;
        }
        if (snaFilter.handledTypes.size() != this.handledTypes.size() || snaFilter.conditions.size() != this.conditions.size()) {
            return false;
        }
        Iterator<SnaMessage.Type> typeIterator = this.handledTypes.iterator();
        while (typeIterator.hasNext()) {
            if (snaFilter.handledTypes.contains((Object)typeIterator.next())) continue;
            return false;
        }
        Iterator<Constraint> constraintIterator = this.conditions.iterator();
        while (constraintIterator.hasNext()) {
            if (snaFilter.conditions.contains(constraintIterator.next())) continue;
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        JSONArray array = new JSONArray();
        Iterator<SnaMessage.Type> iterator = this.handledTypes.iterator();
        while (iterator.hasNext()) {
            array.put((Object)iterator.next().name());
        }
        object.put("types", (Object)array);
        object.put("sender", (Object)this.sender);
        object.put("pattern", this.isPattern);
        object.put("complement", this.isComplement);
        array = new JSONArray();
        Iterator<Constraint> constraints = this.conditions.iterator();
        while (constraints.hasNext()) {
            array.put((Object)new JSONObject(constraints.next().getJSON()));
        }
        object.put("conditions", (Object)array);
        return object;
    }

    public String getJSON() {
        return this.toJSONObject().toString();
    }
}

