/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeMethod;
import org.eclipse.sensinact.gateway.core.method.DescribeResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.DescribeStringResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class DescribeStringResponseBuilder
extends DescribeResponseBuilder<String> {
    private static final String DEFAULT_DELIMITER = ",";
    private String delimiter;

    protected DescribeStringResponseBuilder(Mediator mediator, String uri, DescribeMethod.DescribeType describeType, String delimiter) {
        super(mediator, uri, describeType);
        this.delimiter = delimiter;
    }

    @Override
    public Class<String> getComponentType() {
        return String.class;
    }

    @Override
    public DescribeStringResponse createAccessMethodResponse(AccessMethodResponse.Status status) {
        DescribeStringResponse response = new DescribeStringResponse(super.getPath(), status, this.describeType);
        if (this.exceptions != null && this.exceptions.size() > 0) {
            Iterator iterator = this.exceptions.iterator();
            JSONArray exceptionsArray = new JSONArray();
            while (iterator.hasNext()) {
                Exception exception = (Exception)iterator.next();
                JSONObject exceptionObject = new JSONObject();
                exceptionObject.put("message", (Object)exception.getMessage());
                StringBuilder buffer = new StringBuilder();
                StackTraceElement[] trace = exception.getStackTrace();
                int length = trace.length;
                for (int index = 0; index < length; ++index) {
                    buffer.append(trace[index].toString());
                    buffer.append("\n");
                }
                exceptionObject.put("trace", (Object)buffer.toString());
                exceptionsArray.put((Object)exceptionObject);
            }
            response.setErrors(exceptionsArray);
        }
        response.setResponse(this.getAccessMethodObjectResult());
        return response;
    }

    @Override
    public DescribeStringResponse createAccessMethodResponse() {
        AccessMethodResponse.Status status = this.exceptions != null && this.exceptions.size() > 0 ? AccessMethodResponse.Status.ERROR : AccessMethodResponse.Status.SUCCESS;
        return this.createAccessMethodResponse(status);
    }

    @Override
    public void setAccessMethodObjectResult(String resultObject) {
        super.push(resultObject);
    }

    @Override
    public String getAccessMethodObjectResult() {
        int index = 0;
        StringBuilder builder = new StringBuilder();
        Enumeration enumeration = super.elements();
        while (enumeration.hasMoreElements()) {
            if (index > 0) {
                builder.append(this.delimiter == null ? DEFAULT_DELIMITER : this.delimiter);
            }
            builder.append((String)enumeration.nextElement());
            ++index;
        }
        return builder.toString();
    }
}

