/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import org.eclipse.sensinact.gateway.core.message.AbstractSnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaErrorfulMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractSnaErrorfulMessage<S extends Enum<S> & SnaMessageSubType>
extends AbstractSnaMessage<S>
implements SnaErrorfulMessage<S> {
    protected AbstractSnaErrorfulMessage(String uri, S type) {
        super(uri, type);
    }

    @Override
    public void setErrors(JSONArray errorsArray) {
        int length = 0;
        if (errorsArray == null || (length = errorsArray.length()) == 0) {
            return;
        }
        JSONArray errors = this.getErrors();
        if (errors == null) {
            errors = new JSONArray();
        }
        for (int index = 0; index < length; ++index) {
            errors.put(errorsArray.get(index));
        }
        super.putValue("errors", (Object)errors);
    }

    protected void setErrors(String message, Throwable exception) {
        JSONArray exceptionsArray = new JSONArray();
        JSONObject exceptionObject = new JSONObject();
        exceptionObject.put("message", (Object)(message == null ? exception.getMessage() : message));
        StringBuilder buffer = new StringBuilder();
        if (exception != null) {
            StackTraceElement[] trace = exception.getStackTrace();
            int length = trace.length;
            for (int index = 0; index < length; ++index) {
                buffer.append(trace[index].toString());
                buffer.append("\n");
            }
        }
        exceptionObject.put("trace", (Object)buffer.toString());
        exceptionsArray.put((Object)exceptionObject);
        this.setErrors(exceptionsArray);
    }

    @Override
    public void setErrors(Exception exception) {
        this.setErrors(null, exception);
    }

    @Override
    public JSONArray getErrors() {
        return (JSONArray)super.get("errors");
    }
}

