/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.message.AbstractMidCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;

public class UnaryMidCallback
extends AbstractMidCallback {
    protected final Mediator mediator;
    protected Recipient recipient;

    public UnaryMidCallback(Mediator mediator, ErrorHandler errorHandler, Recipient recipient, long lifetime) {
        super(true);
        this.mediator = mediator;
        this.recipient = recipient;
        super.setTimeout(lifetime <= 10000L ? -1L : System.currentTimeMillis() + lifetime);
        super.setErrorHandler(errorHandler);
    }

    @Override
    public void doCallback(SnaMessage<?> message) throws MidCallbackException {
        try {
            this.recipient.callback(this.getName(), new SnaMessage[]{message});
        }
        catch (Exception e) {
            throw new MidCallbackException(e);
        }
    }
}

