/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.props.TypedKey;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIface;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;

public class RemoteAccessMethodExecutable
implements Executable<SensinactCoreBaseIface, String> {
    public static final String ARGUMENTS = "arguments";
    public static final String SUBSCRIPTION_ID = "subscriptionId";
    public static final String CONDITIONS = "conditions";
    public static final String RECIPIENT = "recipient";
    public static final String VALUE = "value";
    public static final TypedKey<Object[]> ARGUMENTS_TK = new TypedKey("arguments", Object[].class, false);
    public static final TypedKey<String> SUBSCRIPTION_ID_TK = new TypedKey("subscriptionId", String.class, false);
    public static final TypedKey<JSONArray> CONDITIONS_TK = new TypedKey("conditions", JSONArray.class, false);
    public static final TypedKey<Recipient> RECIPIENT_TK = new TypedKey("recipient", Recipient.class, false);
    public static final TypedKey<Object> VALUE_TK = new TypedKey("value", Object.class, false);
    private AccessMethod.Type method;
    private String publicKey;
    private String serviceProvider;
    private String resource;
    private String service;
    private String attribute;
    private Map<TypedKey<?>, Object> props;
    private Mediator mediator;

    public RemoteAccessMethodExecutable(Mediator mediator, AccessMethod.Type method, String publicKey) {
        this.mediator = mediator;
        this.method = method;
        this.publicKey = publicKey;
        this.props = new HashMap();
    }

    public AccessMethod.Type getMethod() {
        return this.method;
    }

    public RemoteAccessMethodExecutable withServiceProvider(String serviceProvider) {
        this.serviceProvider = serviceProvider;
        return this;
    }

    public RemoteAccessMethodExecutable withService(String service) {
        this.service = service;
        return this;
    }

    public RemoteAccessMethodExecutable withResource(String resource) {
        this.resource = resource;
        return this;
    }

    public RemoteAccessMethodExecutable withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public <P> RemoteAccessMethodExecutable with(String name, Class<P> type, P prop) {
        TypedKey key = new TypedKey(name, type, false);
        this.props.put(key, prop);
        return this;
    }

    public <P> RemoteAccessMethodExecutable with(TypedKey<P> key, P prop) {
        this.props.put(key, prop);
        return this;
    }

    public String execute(SensinactCoreBaseIface core) throws Exception {
        String json = null;
        if (core == null) {
            return json;
        }
        String provider = this.serviceProvider.substring(this.serviceProvider.indexOf(58) + 1);
        switch (this.method.name()) {
            case "ACT": {
                json = core.act(this.publicKey, provider, this.service, this.resource, ((JSONArray)CastUtils.cast(JSONArray.class, (Object)this.props.get(ARGUMENTS_TK))).toString());
                break;
            }
            case "GET": {
                json = core.get(this.publicKey, provider, this.service, this.resource, this.attribute);
                break;
            }
            case "SET": {
                json = core.set(this.publicKey, provider, this.service, this.resource, this.attribute, ((JSONArray)CastUtils.cast(JSONArray.class, (Object)this.props.get(VALUE_TK))).toString());
                break;
            }
            case "SUBSCRIBE": 
            case "UNSUBSCRIBE": {
                break;
            }
        }
        return json;
    }
}

