/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.filter.geojson;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.sensinact.gateway.core.filtering.Filtering;
import org.eclipse.sensinact.gateway.core.filtering.FilteringType;
import org.eclipse.sensinact.gateway.util.LocationUtils;
import org.eclipse.sensinact.gateway.util.json.JSONObjectStatement;
import org.eclipse.sensinact.gateway.util.json.JSONTokenerStatement;
import org.eclipse.sensinact.gateway.util.json.JSONValidator;
import org.eclipse.sensinact.gateway.util.location.Segment;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilteringType(value={"geojson"})
@Component(immediate=true, service={Filtering.class})
public class GeoJSONFiltering
implements Filtering {
    public static final String GEOJSON = "geojson";
    private static Logger LOG = LoggerFactory.getLogger((String)GeoJSONFiltering.class.getCanonicalName());
    private static final JSONObjectStatement STATEMENT = new JSONObjectStatement(new JSONTokenerStatement("{ \"type\": \"Feature\", \"properties\": {\t    \"name\": $(name)  },  \"geometry\": {     \"type\": \"Point\",     \"coordinates\": [ $(longitude),$(latitude)]   }}"));

    public boolean handle(String type) {
        return GEOJSON.equals(type);
    }

    public String apply(String definition, Object result) {
        JSONValidator.JSONToken token;
        JSONObject obj = new JSONObject(definition);
        boolean output = obj.optBoolean("output");
        if (!output) {
            return String.valueOf(result);
        }
        JSONValidator validator = new JSONValidator(String.valueOf(result));
        StringBuilder builder = new StringBuilder();
        builder.append("{\"type\": \"FeatureCollection\", \"features\": [");
        int count = 0;
        int index = 0;
        HashSet names = new HashSet();
        HashMap<Integer, String> locationMap = new HashMap<Integer, String>();
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        while ((token = validator.nextToken()) != null) {
            Integer ind;
            if (token.ordinal() == JSONValidator.JSONToken.JSON_OBJECT_OPENING.ordinal()) {
                ++count;
            }
            if (token.ordinal() == JSONValidator.JSONToken.JSON_OBJECT_CLOSING.ordinal()) {
                ind = count;
                nameMap.remove(ind);
                locationMap.remove(ind);
                --count;
            }
            if (token.ordinal() == JSONValidator.JSONToken.JSON_OBJECT_ITEM.ordinal() && token.getContext().key.equals("name")) {
                ind = count;
                String name = (String)token.getContext().value;
                if (name != null) {
                    nameMap.put(ind, name);
                }
                String location = null;
                location = (String)locationMap.get(ind);
                if (location != null && !names.contains(name) && this.writeLocation(name, location, index, builder)) {
                    ++index;
                }
            }
            if (token.ordinal() != JSONValidator.JSONToken.JSON_OBJECT_ITEM.ordinal() || !token.getContext().key.equals("location")) continue;
            ind = count;
            String location = (String)token.getContext().value;
            if (location != null) {
                locationMap.put(ind, location);
            }
            String name = null;
            name = (String)nameMap.get(ind);
            if (name == null || names.contains(name) || !this.writeLocation(name, location, index, builder)) continue;
            ++index;
        }
        builder.append("]}");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeLocation(String name, String location, int index, StringBuilder builder) {
        try {
            char sep;
            int pos;
            char[] seps = new char[]{':', ',', ' '};
            for (pos = 0; pos < seps.length && (sep = location.indexOf(58)) < '\u0000'; ++pos) {
            }
            if (pos == seps.length) {
                sep = '\u0000';
                return sep != '\u0000';
            }
            sep = seps[pos];
            String[] locationElements = location.split(new String(new char[]{sep}));
            double latitude = Double.parseDouble(locationElements[0]);
            double longitude = Double.parseDouble(locationElements[1]);
            STATEMENT.apply("latitude", (Object)latitude);
            STATEMENT.apply("longitude", (Object)longitude);
            STATEMENT.apply("name", (Object)name);
            if (index > 0) {
                builder.append(",");
            }
            builder.append(STATEMENT.toString());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("could not write location", (Throwable)e);
        }
        finally {
            STATEMENT.reset();
        }
        return false;
    }

    public String getLDAPComponent(String definition) {
        String ldapFilter = null;
        try {
            JSONObject obj = new JSONObject(definition);
            double lat = obj.getDouble("latitude");
            double lng = obj.getDouble("longitude");
            double distance = obj.getDouble("distance");
            Segment rad0 = null;
            Segment rad90 = null;
            int bearing0 = Double.valueOf(LocationUtils.fromReverseClockedDegreesAngleToNorthOrientedBearing((double)0.0)).intValue();
            int bearing90 = Double.valueOf(LocationUtils.fromReverseClockedDegreesAngleToNorthOrientedBearing((double)90.0)).intValue();
            if (distance < 200.0) {
                rad0 = LocationUtils.getSphericalEarthModelCoordinates((double)lat, (double)lng, (int)bearing0, (double)distance);
                rad90 = LocationUtils.getSphericalEarthModelCoordinates((double)lat, (double)lng, (int)bearing90, (double)distance);
            } else {
                rad0 = LocationUtils.getElipsoidEarthModelCoordinates((double)lat, (double)lng, (double)bearing0, (double)distance);
                rad90 = LocationUtils.getElipsoidEarthModelCoordinates((double)lat, (double)lng, (double)bearing90, (double)distance);
            }
            double diffLat = Math.abs(rad0.getLat1() - rad0.getLat2());
            double diffLng = Math.abs(rad90.getLng1() - rad90.getLng2());
            ldapFilter = String.format("(&(latitude <= %s)(latitude >= %s)(longitude <= %s)(longitude >= %s))", lat + diffLat, lat - diffLat, lng + diffLng, lng - diffLng);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ldapFilter;
    }
}

