/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.user.openid;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.security.user.openid.Endpoints;
import org.eclipse.sensinact.gateway.core.security.user.openid.KeyCollection;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdUserKeyBuilderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdUserKeyBuilderConfig.class);
    private static final String AUTHENTICATION_SERVICE_CONFIG = "authentication.service.config";
    private String discoveryURL = null;
    private String clientId;
    private String clientSecret;
    private URI authEP;
    private URI tokenEP;
    private URI userinfoEP;
    private URI logoutEP;
    private List<KeyCollection.Keys> publicKeys;
    private final AtomicBoolean configured = new AtomicBoolean(false);
    private ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();

    public OpenIdUserKeyBuilderConfig(Mediator mediator) {
        if (mediator == null || mediator.getProperty("org.eclipse.sensinact.security.keybuilder.openid.discoveryURL") == null) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(AUTHENTICATION_SERVICE_CONFIG));
                this.discoveryURL = properties.getProperty("org.eclipse.sensinact.security.keybuilder.openid.discoveryURL").toString();
                this.clientId = properties.getProperty("org.eclipse.sensinact.security.keybuilder.openid.client_id").toString();
                this.clientSecret = properties.getProperty("org.eclipse.sensinact.security.keybuilder.openid.client_secret").toString();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("Error while loading configuration", e);
            }
        } else {
            this.discoveryURL = mediator.getProperty("org.eclipse.sensinact.security.keybuilder.openid.discoveryURL").toString();
            this.clientId = mediator.getProperty("org.eclipse.sensinact.security.keybuilder.openid.client_id").toString();
            this.clientSecret = mediator.getProperty("org.eclipse.sensinact.security.keybuilder.openid.client_secret").toString();
        }
        if (this.discoveryURL != null) {
            this.worker.scheduleWithFixedDelay(() -> this.loadEndpoints(), 1L, 20L, TimeUnit.SECONDS);
        } else {
            LOG.error("Unable to load connected OpenID server endpoints");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEndpoints() {
        try {
            ConnectionConfigurationImpl connection = new ConnectionConfigurationImpl();
            connection.setUri(this.discoveryURL);
            connection.setAccept("application/json");
            SimpleRequest req = new SimpleRequest((ConnectionConfiguration)connection);
            SimpleResponse resp = null;
            resp = (SimpleResponse)req.send();
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(resp.getContent(), Endpoints.class);
            this.authEP = new URI(endpoints.getAuthEP());
            this.tokenEP = new URI(endpoints.getTokenEP());
            this.userinfoEP = new URI(endpoints.getUserinfoEP());
            this.logoutEP = new URI(endpoints.getLogoutEP());
            connection = new ConnectionConfigurationImpl();
            connection.setUri(endpoints.getCertsEP());
            connection.setAccept("application/json");
            req = new SimpleRequest((ConnectionConfiguration)connection);
            resp = (SimpleResponse)req.send();
            mapper = new ObjectMapper();
            KeyCollection keyCollection = (KeyCollection)mapper.readValue(resp.getContent(), KeyCollection.class);
            this.publicKeys = keyCollection.getKeys();
            this.worker.shutdownNow();
            this.worker = null;
            AtomicBoolean atomicBoolean = this.configured;
            synchronized (atomicBoolean) {
                this.configured.set(true);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public URI getAuthEP() {
        return this.authEP;
    }

    public URI getTokenEP() {
        return this.tokenEP;
    }

    public URI getUserinfoEP() {
        return this.userinfoEP;
    }

    public URI getLogoutEP() {
        return this.logoutEP;
    }

    public List<KeyCollection.Keys> getPublicKeys() {
        return this.publicKeys;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigured() {
        boolean configured = false;
        AtomicBoolean atomicBoolean = this.configured;
        synchronized (atomicBoolean) {
            configured = this.configured.get();
        }
        return configured;
    }

    public void finalize() {
        if (this.worker != null && !this.worker.isShutdown()) {
            this.worker.shutdownNow();
        }
        this.worker = null;
    }
}

