/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.protocol.http.client.mid;

import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.protocol.http.client.Response;
import org.eclipse.sensinact.gateway.protocol.http.client.mid.HttpResponseException;
import org.eclipse.sensinact.gateway.protocol.http.client.mid.MidClientListener;
import org.eclipse.sensinact.gateway.protocol.http.client.mid.Reusable;
import org.eclipse.sensinact.gateway.util.stack.AbstractStackEngineHandler;

public class MidClient<RESPONSE extends Response, REQUEST extends Request<RESPONSE> & Reusable>
extends AbstractStackEngineHandler<REQUEST> {
    protected static Logger LOG = Logger.getLogger(MidClient.class.getName());
    public static final int DEFAULT_MAX_STACK_SIZE = 50;
    public static final int DEFAULT_INITIAL_DELAY = 60000;
    public static final int DEFAULT_MAX_DELAY = 14400000;
    protected REQUEST reactivation;
    protected final MidClientListener<RESPONSE> listener;
    protected int initialDelay;
    protected int maxDelay;
    protected int currentDelay;
    protected boolean reactivate;

    public MidClient(MidClientListener<RESPONSE> listener) {
        this(listener, 50);
    }

    public MidClient(MidClientListener<RESPONSE> listener, int maxStackSize) {
        this.eventEngine.setMaxStackSize(maxStackSize <= 0 ? 50 : maxStackSize);
        this.listener = listener;
        this.currentDelay = -1;
        this.initialDelay = -1;
        this.maxDelay = -1;
        this.reactivate = false;
    }

    public void setReactivationRequest(REQUEST reactivation) {
        this.reactivation = reactivation;
    }

    public int getMaxStackSize() {
        return this.eventEngine.getMaxStackSize();
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public int getInitialDelay() {
        if (this.initialDelay < 0) {
            return 60000;
        }
        return this.initialDelay;
    }

    public void setMaxDelay(int maxDelay) {
        this.maxDelay = maxDelay;
    }

    public int getMaxDelay() {
        if (this.maxDelay < 0) {
            return 14400000;
        }
        return this.maxDelay;
    }

    public void updateDelay() {
        if (this.currentDelay < 0) {
            this.currentDelay = this.getInitialDelay();
        } else if (this.currentDelay < this.getMaxDelay()) {
            int tmpDelay = this.currentDelay * 2;
            this.currentDelay = tmpDelay > this.getMaxDelay() ? this.getMaxDelay() : tmpDelay;
        }
    }

    public int getCurrentDelay() {
        return this.currentDelay;
    }

    protected void resetDelay() {
        this.currentDelay = -1;
    }

    public void addRequest(REQUEST request) {
        this.eventEngine.push(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(REQUEST element) {
        Response response = null;
        try {
            if (this.reactivate && this.reactivation != null) {
                this.reactivate = false;
                response = this.reactivation.send();
                this.listener.respond(response);
            }
            if ((response = (Response)element.send()).getStatusCode() >= 400) {
                throw new HttpResponseException(response.getStatusCode(), response.getContent(), response.getHeaders());
            }
            this.resetDelay();
        }
        catch (HttpResponseException e) {
            if (this.handleHttpError(e)) {
                this.handleError(e, element);
            } else {
                this.resetDelay();
                this.listener.respond(response);
            }
        }
        catch (Exception e) {
            this.handleError(e, element);
        }
        finally {
            this.listener.respond(response);
        }
    }

    protected boolean handleHttpError(HttpResponseException e) {
        return true;
    }

    protected void handleError(Exception e, REQUEST element) {
        this.updateDelay();
        this.reactivate = true;
        this.eventEngine.locked((long)this.getCurrentDelay());
        if (((Reusable)element).isReusable()) {
            this.eventEngine.push((Object)((Request)((Object)((Reusable)element).copy())));
        }
    }
}

