/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.XmlDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlEscaped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmlModelParsingContext
extends XmlDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(XmlModelParsingContext.class);
    private XmlModelParsingContext next;
    protected StringBuilder textContent = new StringBuilder();

    public XmlModelParsingContext(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    public String[] escaped() {
        XmlEscaped escaped = this.getClass().getAnnotation(XmlEscaped.class);
        if (escaped != null) {
            return escaped.value();
        }
        return new String[0];
    }

    public void characters(char[] chrs, int start, int length) throws SAXException {
        this.textContent.append(chrs, start, length);
    }

    public void ignorableWhitespace(char[] chrs, int start, int length) throws SAXException {
        this.textContent.append(chrs, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        LOG.debug("processing instruction : \n\t" + target + " \n\t " + data);
    }

    public void skippedEntity(String name) throws SAXException {
        LOG.debug("skipped entity : " + name);
    }

    public XmlModelParsingContext next() {
        return this.next;
    }

    protected void setNext(XmlModelParsingContext next) {
        this.next = next;
    }

    public void end() {
        super.mapTag(this.textContent.toString());
    }
}

