/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ConnectorCustomizer;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.config.HttpMappingProtocolStackEndpointDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.HttpMappingProtocolStackConnectorCustomizer;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.packet.TaskAwareHttpResponsePacket;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContextHandler;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextHandler;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpProtocolStackEndpointTasksDescription;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"service.pid=sensinact.http.endpoint"})
public class HttpMappingProtocolStackEndpointFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMappingProtocolStackEndpointFactory.class);
    public static final String FACTORY_PID = "sensinact.http.endpoint";
    public static final String ENDPOINT_CONFIGURATION_PROP = "sensinact.http.endpoint.config";
    public static final String ENDPOINT_RESOURCES_CONFIGURATION_PROP = "sensinact.http.endpoint.resources.config";
    public static final String ENDPOINT_TASKS_CONFIGURATION_PROP = "sensinact.http.endpoint.tasks.config";
    public static final Modifiable DEFAULT_MODIFIABLE = Modifiable.MODIFIABLE;
    private Map<String, SimpleHttpProtocolStackEndpoint> endpoints;
    private BundleContext bundleContext;

    @Activate
    public void activate(ComponentContext ccontext) {
        this.endpoints = new HashMap<String, SimpleHttpProtocolStackEndpoint>();
        this.bundleContext = ccontext.getBundleContext();
    }

    public String getName() {
        return FACTORY_PID;
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        File taskConfigFile;
        File resourcesConfigFile;
        String resourcesConfig;
        File endpointConfigFile;
        this.deleted(pid);
        HttpMediator mediator = new HttpMediator(this.bundleContext);
        mediator.setTaskProcessingContextHandler(this.getProcessingContextHandler(mediator));
        mediator.setTaskProcessingContextFactory(this.getTaskProcessingContextFactory(mediator));
        mediator.setChainedTaskProcessingContextFactory(this.getChainedTaskProcessingContextFactory(mediator));
        String endpointConfig = String.valueOf(properties.get(ENDPOINT_CONFIGURATION_PROP));
        HttpMappingProtocolStackEndpointDescription endpointDescription = null;
        if (endpointConfig != null && (endpointConfigFile = new File(endpointConfig)).exists()) {
            try {
                FileInputStream in = new FileInputStream(endpointConfigFile);
                ObjectMapper mapper = new ObjectMapper();
                endpointDescription = (HttpMappingProtocolStackEndpointDescription)mapper.readValue((InputStream)in, HttpMappingProtocolStackEndpointDescription.class);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (endpointDescription == null) {
            endpointDescription = new HttpMappingProtocolStackEndpointDescription();
        }
        if ((resourcesConfig = String.valueOf(properties.get(ENDPOINT_RESOURCES_CONFIGURATION_PROP))) != null && !(resourcesConfigFile = new File(resourcesConfig)).exists()) {
            resourcesConfig = null;
        }
        HttpProtocolStackEndpointTasksDescription tasksDescription = null;
        String taskConfig = String.valueOf(properties.get(ENDPOINT_TASKS_CONFIGURATION_PROP));
        if (taskConfig != null && (taskConfigFile = new File(taskConfig)).exists()) {
            try {
                FileInputStream in = new FileInputStream(taskConfigFile);
                ObjectMapper mapper = new ObjectMapper();
                tasksDescription = (HttpProtocolStackEndpointTasksDescription)mapper.readValue((InputStream)in, HttpProtocolStackEndpointTasksDescription.class);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        ExtModelConfiguration<TaskAwareHttpResponsePacket> configuration = this.buildConfiguration(mediator, endpointDescription, resourcesConfig);
        SimpleHttpProtocolStackEndpoint endpoint = null;
        try {
            endpoint = new SimpleHttpProtocolStackEndpoint(mediator);
        }
        catch (Exception e) {
            LOG.error("Unable to create Endpoint", (Throwable)e);
        }
        if (endpoint == null) {
            return;
        }
        if (tasksDescription != null) {
            endpoint.registerAdapters(tasksDescription);
        }
        try {
            endpoint.connect(configuration);
            this.endpoints.put(pid, endpoint);
        }
        catch (InvalidProtocolStackException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleted(String pid) {
        SimpleHttpProtocolStackEndpoint endpoint = this.endpoints.remove(pid);
        if (endpoint == null) {
            return;
        }
        endpoint.stop();
    }

    private final ExtModelConfiguration<TaskAwareHttpResponsePacket> buildConfiguration(HttpMediator mediator, HttpMappingProtocolStackEndpointDescription endpointDescription, String resourceConfig) {
        byte serviceBuildPolicy = Arrays.stream(endpointDescription.getServiceBuildPolicy()).map(s -> SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)s).getPolicy()).reduce(0, (b1, b2) -> b1.byteValue() | b2.byteValue()).byteValue();
        byte resourceBuildPolicy = Arrays.stream(endpointDescription.getResourceBuildPolicy()).map(s -> SensiNactResourceModelConfiguration.BuildPolicy.valueOf((String)s).getPolicy()).reduce(0, (b1, b2) -> b1.byteValue() | b2.byteValue()).byteValue();
        Modifiable modifiable = null;
        try {
            modifiable = Modifiable.valueOf((String)endpointDescription.getModifiable().toUpperCase());
        }
        catch (Exception e) {
            modifiable = DEFAULT_MODIFIABLE;
        }
        ExtModelConfiguration configuration = ExtModelConfigurationBuilder.instance((Mediator)mediator, TaskAwareHttpResponsePacket.class).withStartAtInitializationTime(endpointDescription.isStartAtInitializationTime()).withServiceBuildPolicy(resourceConfig == null ? SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy() : serviceBuildPolicy).withResourceBuildPolicy(resourceConfig == null ? SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy() : resourceBuildPolicy).withDefaultModifiable(modifiable).withObserved(Arrays.asList(endpointDescription.getObserved())).build(new Object[]{resourceConfig, endpointDescription.getDefaults()});
        HttpMappingProtocolStackConnectorCustomizer customizer = new HttpMappingProtocolStackConnectorCustomizer((Mediator)mediator, configuration, endpointDescription);
        configuration.setConnectorCustomizer((ConnectorCustomizer)customizer);
        return configuration;
    }

    protected HttpTaskProcessingContextHandler getProcessingContextHandler(HttpMediator mediator) {
        return new DefaultHttpTaskProcessingContextHandler();
    }

    public HttpTaskProcessingContextFactory getTaskProcessingContextFactory(HttpMediator mediator) {
        return new DefaultHttpTaskProcessingContextFactory((Mediator)mediator);
    }

    public HttpChainedTaskProcessingContextFactory getChainedTaskProcessingContextFactory(HttpMediator mediator) {
        return new DefaultHttpChainedTaskProcessingContextFactory((Mediator)mediator);
    }
}

