/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.local;

import org.apache.aries.rsa.discovery.local.LocalDiscovery;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker<EndpointEventListener, EndpointEventListener> listenerTracker;
    private LocalDiscovery localDiscovery;

    public void start(BundleContext context) {
        this.localDiscovery = new LocalDiscovery();
        this.listenerTracker = new EPListenerTracker(context, this.localDiscovery);
        this.listenerTracker.open();
        this.localDiscovery.processExistingBundles(context.getBundles());
        context.addBundleListener((BundleListener)this.localDiscovery);
    }

    public void stop(BundleContext context) {
        this.listenerTracker.close();
        context.removeBundleListener((BundleListener)this.localDiscovery);
    }

    private final class EPListenerTracker
    extends ServiceTracker<EndpointEventListener, EndpointEventListener> {
        private final LocalDiscovery localDiscovery;

        private EPListenerTracker(BundleContext context, LocalDiscovery localDiscovery) {
            super(context, EndpointEventListener.class, null);
            this.localDiscovery = localDiscovery;
        }

        public EndpointEventListener addingService(ServiceReference<EndpointEventListener> reference) {
            EndpointEventListener service = (EndpointEventListener)super.addingService(reference);
            this.localDiscovery.addListener(reference, service);
            return service;
        }

        public void modifiedService(ServiceReference<EndpointEventListener> reference, EndpointEventListener service) {
            super.modifiedService(reference, (Object)service);
            this.localDiscovery.removeListener(service);
            this.localDiscovery.addListener(reference, service);
        }

        public void removedService(ServiceReference<EndpointEventListener> reference, EndpointEventListener service) {
            super.removedService(reference, (Object)service);
            this.localDiscovery.removeListener(service);
        }
    }
}

