/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.AbstractResponseWrapper;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.internal.CallbackWebSocketServlet;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketResponseWrapper
extends AbstractResponseWrapper {
    CallbackWebSocketServlet wrapper;

    public WebSocketResponseWrapper(CallbackWebSocketServlet wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void flush() {
        JSONObject attrs = null;
        if (this.attributes != null && !this.attributes.isEmpty()) {
            attrs = new JSONObject();
            for (String key : this.attributes.keySet()) {
                try {
                    attrs.put(key, (Object)AbstractResponseWrapper.getParameter(this.attributes, key));
                }
                catch (UnsupportedEncodingException | JSONException e) {
                    AbstractResponseWrapper.LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if (this.content != null && this.content.length > 0) {
            try {
                JSONObject obj = new JSONObject(new String(this.content));
                if (attrs != null) {
                    obj.put("attributes", (Object)attrs);
                }
                if (this.statusCode > 0) {
                    obj.put("statusCode", this.statusCode);
                }
                this.wrapper.writeMessage(obj.toString());
            }
            catch (JSONException e) {
                this.wrapper.writeMessage(new String(this.content));
            }
            return;
        }
        if (attrs != null) {
            if (this.statusCode > 0) {
                attrs.put("statusCode", this.statusCode);
            }
            this.wrapper.writeMessage(attrs.toString());
            return;
        }
        if (this.statusCode > 0) {
            this.wrapper.writeMessage(String.valueOf(this.statusCode));
        }
    }
}

