/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.SnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.directive.CreateDirective;
import org.eclipse.sensinact.gateway.core.security.dao.directive.DeleteDirective;
import org.eclipse.sensinact.gateway.core.security.dao.directive.KeyDirective;
import org.eclipse.sensinact.gateway.core.security.dao.directive.SelectDirective;
import org.eclipse.sensinact.gateway.core.security.dao.directive.UpdateDirective;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Immutable;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSnaDAO<E extends SnaEntity>
implements SnaDAO<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSnaDAO.class);
    public static final String REQUEST_VAR = "#VAR#";
    protected final Class<E> entityType;
    protected final DataStoreService dataStoreService;
    protected final Map<String, UserDefinedSelectStatement> userDefinedSelectStatements;

    abstract void created(E var1, long var2);

    abstract void updated(int var1);

    abstract void deleted(int var1);

    private static String formatQuery(String query, String ... variables) {
        String formatedQuery = new String(query);
        if (variables != null) {
            for (String variable : variables) {
                formatedQuery = formatedQuery.replaceFirst(REQUEST_VAR, variable);
            }
        }
        formatedQuery = formatedQuery.replace('\n', ' ');
        return formatedQuery;
    }

    protected static boolean isImmutable(Immutable immutable, Immutable.Operation op) {
        for (Immutable.Operation operation : immutable.operation()) {
            if (!operation.equals((Object)op)) continue;
            return true;
        }
        return false;
    }

    AbstractSnaDAO(Class<E> entityType, DataStoreService dataStoreService) {
        this.dataStoreService = dataStoreService;
        this.entityType = entityType;
        this.userDefinedSelectStatements = new HashMap<String, UserDefinedSelectStatement>();
    }

    public Long create(String query, String ... variables) throws DataStoreException {
        return this.dataStoreService.insert(AbstractSnaDAO.formatQuery(query, variables));
    }

    public Integer update(String query, String ... variables) throws DataStoreException {
        return this.dataStoreService.update(AbstractSnaDAO.formatQuery(query, variables));
    }

    public Integer delete(String query, String ... variables) throws DataStoreException {
        return this.dataStoreService.delete(AbstractSnaDAO.formatQuery(query, variables));
    }

    @Override
    public List<E> select(String name, String ... variables) throws DAOException, DataStoreException {
        UserDefinedSelectStatement userDefinedSelectStatement = this.userDefinedSelectStatements.get(name);
        if (userDefinedSelectStatement == null) {
            return this.select();
        }
        String query = userDefinedSelectStatement.getStatement();
        JSONArray array = this.selectStatement(query, variables);
        int length = array == null ? 0 : array.length();
        ArrayList<E> entitiesList = new ArrayList<E>(length);
        for (int index = 0; index < length; ++index) {
            try {
                JSONObject jsonObject = array.getJSONObject(index);
                entitiesList.add(this.entityType.getConstructor(JSONObject.class).newInstance(jsonObject));
                continue;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return entitiesList;
    }

    @Override
    public List<E> select(Map<String, Object> whereDirectives) throws DAOException, DataStoreException {
        if (whereDirectives == null) {
            return this.select();
        }
        SelectDirective selectDirective = SelectDirective.getSelectDirective(this.entityType);
        for (Map.Entry<String, Object> entry : whereDirectives.entrySet()) {
            selectDirective.where(entry.getKey(), entry.getValue());
        }
        JSONArray array = this.selectStatement(selectDirective.toString(), new String[0]);
        int length = array == null ? 0 : array.length();
        ArrayList<E> entitiesList = new ArrayList<E>(length);
        for (int index = 0; index < length; ++index) {
            try {
                JSONObject jsonObject = array.getJSONObject(index);
                entitiesList.add(this.entityType.getConstructor(JSONObject.class).newInstance(jsonObject));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return entitiesList;
    }

    @Override
    public E select(List<SnaEntity.Key> keyMap) throws DAOException, DataStoreException {
        KeyDirective keyDirective = KeyDirective.createKeyDirective(this.entityType);
        keyDirective.assign(keyMap);
        E entity = this.getEntity(this.entityType, keyDirective);
        return entity;
    }

    private JSONArray selectStatement(String query, String ... variables) throws DataStoreException {
        return this.dataStoreService.select(AbstractSnaDAO.formatQuery(query, variables));
    }

    protected void registerUserDefinedSelectStatement(String name, UserDefinedSelectStatement statement) {
        this.userDefinedSelectStatements.put(name, statement);
    }

    protected E getEntity(Class<E> entityType, KeyDirective keyDirective) throws DataStoreException {
        SnaEntity entity = null;
        List<E> entities = this.getEntities(entityType, keyDirective);
        if (!entities.isEmpty()) {
            entity = (SnaEntity)entities.get(0);
        }
        return (E)entity;
    }

    protected <E extends SnaEntity> List<E> getEntities(Class<E> entityType) throws DataStoreException {
        return this.getEntities(entityType, null);
    }

    public <E extends SnaEntity> List<E> getEntities(Class<E> entityType, KeyDirective keyDirective) throws DataStoreException {
        SelectDirective selectDirective = SelectDirective.getSelectDirective(entityType);
        selectDirective.join(keyDirective);
        JSONArray array = this.selectStatement(selectDirective.toString(), new String[0]);
        int length = array == null ? 0 : array.length();
        ArrayList<E> entitiesList = new ArrayList<E>(length);
        Constructor<E> constructor = null;
        if (length > 0) {
            try {
                constructor = entityType.getConstructor(JSONObject.class);
                for (int index = 0; index < length; ++index) {
                    JSONObject jsonObject = array.getJSONObject(index);
                    entitiesList.add(constructor.newInstance(jsonObject));
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return entitiesList;
    }

    @Override
    public List<E> select() throws DAOException, DataStoreException {
        List<E> entities = this.getEntities(this.entityType);
        return entities;
    }

    @Override
    public void create(E entity) throws DAOException, DataStoreException {
        CreateDirective createDirective = CreateDirective.getCreateDirective(entity);
        this.created(entity, this.create(createDirective.toString(), new String[0]));
    }

    @Override
    public void update(E entity) throws DAOException, DataStoreException {
        UpdateDirective updateDirective = UpdateDirective.getUpdateDirective(entity);
        this.updated(this.update(updateDirective.toString(), new String[0]));
    }

    @Override
    public void delete(E entity) throws DAOException, DataStoreException {
        DeleteDirective deleteDirective = DeleteDirective.getDeleteDirective(entity);
        this.deleted(this.delete(deleteDirective.toString(), new String[0]));
    }

    protected class UserDefinedSelectStatement {
        private URL definition;
        private String statement = null;

        protected UserDefinedSelectStatement(URL definition) {
            this.definition = definition;
        }

        protected String getStatement() {
            if (this.statement == null) {
                try {
                    byte[] statementBytes = IOUtils.read((InputStream)this.definition.openStream(), (boolean)true);
                    this.statement = new String(statementBytes);
                }
                catch (Exception e) {
                    this.statement = SelectDirective.getSelectDirective(AbstractSnaDAO.this.entityType).toString();
                }
            }
            return this.statement;
        }
    }
}

