/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server;

import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionDescriptor.class);
    public final String clientID;
    public final Channel channel;
    public final boolean cleanSession;
    private final AtomicReference<ConnectionState> channelState = new AtomicReference<ConnectionState>(ConnectionState.DISCONNECTED);

    public ConnectionDescriptor(String clientID, Channel session, boolean cleanSession) {
        this.clientID = clientID;
        this.channel = session;
        this.cleanSession = cleanSession;
    }

    public void abort() {
        LOG.info("closing the channel");
        this.channel.close();
    }

    public boolean assignState(ConnectionState expected, ConnectionState newState) {
        return this.channelState.compareAndSet(expected, newState);
    }

    public String toString() {
        return "ConnectionDescriptor{clientID=" + this.clientID + ", cleanSession=" + this.cleanSession + ", state=" + (Object)((Object)this.channelState.get()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionDescriptor that = (ConnectionDescriptor)o;
        if (this.clientID != null ? !this.clientID.equals(that.clientID) : that.clientID != null) {
            return false;
        }
        return !(this.channel == null ? that.channel != null : !this.channel.equals(that.channel));
    }

    public int hashCode() {
        int result = this.clientID != null ? this.clientID.hashCode() : 0;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        return result;
    }

    public static enum ConnectionState {
        DISCONNECTED,
        SENDACK,
        SESSION_CREATED,
        MESSAGES_REPUBLISHED,
        ESTABLISHED,
        SUBSCRIPTIONS_REMOVED,
        MESSAGES_DROPPED,
        INTERCEPTORS_NOTIFIED;

    }
}

