/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.test;

import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.manager.application.AppLifecycleTrigger;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestLifeCycle {
    private ApplicationStatus status;
    private ApplicationService service = (ApplicationService)Mockito.mock(ApplicationService.class);

    @BeforeEach
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ResourceImpl resource = (ResourceImpl)Mockito.mock(ResourceImpl.class);
        Attribute attribute = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)attribute.getValue()).thenAnswer((Answer)new Answer<ApplicationStatus>(){

            public ApplicationStatus answer(InvocationOnMock invocation) throws Throwable {
                return TestLifeCycle.this.status;
            }
        });
        Mockito.when((Object)resource.getAttribute("value")).thenReturn((Object)attribute);
        Mockito.when((Object)this.service.getResource("status")).thenReturn((Object)resource);
    }

    @Test
    public void testNormalCycle() throws Exception {
        AppLifecycleTrigger trigger = new AppLifecycleTrigger(this.service);
        this.status = ApplicationStatus.valueOf((String)"INSTALLED");
        ApplicationStatus result = (ApplicationStatus)trigger.execute((Object)new AccessMethodResponseBuilder("AppManager/test/START", null){

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }
        });
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"RESOLVING")));
        this.status = ApplicationStatus.valueOf((String)"RESOLVING");
        result = (ApplicationStatus)trigger.execute((Object)new AccessMethodResponseBuilder("AppManager/test/START", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }
        });
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"ACTIVE")));
        this.status = ApplicationStatus.valueOf((String)"ACTIVE");
        result = (ApplicationStatus)trigger.execute((Object)new AccessMethodResponseBuilder("AppManager/test/STOP", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }
        });
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"INSTALLED")));
        this.status = ApplicationStatus.valueOf((String)"INSTALLED");
        result = (ApplicationStatus)trigger.execute((Object)new AccessMethodResponseBuilder("AppManager/test/UNINSTALL", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }
        });
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"UNINSTALLED")));
    }

    @Test
    public void testUnresolvedCycle() throws Exception {
        AppLifecycleTrigger trigger = new AppLifecycleTrigger(this.service);
        this.status = ApplicationStatus.valueOf((String)"INSTALLED");
        ApplicationStatus result = (ApplicationStatus)trigger.execute((Object)new AccessMethodResponseBuilder("AppManager/test/START", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }

            public boolean hasError() {
                return true;
            }
        });
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"UNRESOLVED")));
        this.status = ApplicationStatus.valueOf((String)"UNRESOLVED");
        result = (ApplicationStatus)trigger.execute((Object)new AccessMethodResponseBuilder("AppManager/test/UNINSTALL", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }
        });
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"UNINSTALLED")));
    }

    @Test
    public void testIncompatibleCycle() throws Exception {
        AppLifecycleTrigger trigger = new AppLifecycleTrigger(this.service);
        AccessMethodResponseBuilder snaMethodResult = new AccessMethodResponseBuilder("AppManager/test/STOP", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }

            public boolean hasError() {
                return true;
            }
        };
        this.status = ApplicationStatus.valueOf((String)"ACTIVE");
        ApplicationStatus result = (ApplicationStatus)trigger.execute((Object)snaMethodResult);
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"INSTALLED")));
        snaMethodResult = new AccessMethodResponseBuilder("AppManager/test/UNINSTALL", null){
            private static final long serialVersionUID = 1L;

            public AccessMethodResponse<?> createAccessMethodResponse(AccessMethodResponse.Status status) {
                return null;
            }

            public Class<?> getComponentType() {
                return Object.class;
            }
        };
        this.status = ApplicationStatus.valueOf((String)"ACTIVE");
        result = (ApplicationStatus)trigger.execute((Object)snaMethodResult);
        Assertions.assertTrue((boolean)snaMethodResult.hasError());
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"ACTIVE")));
        this.status = ApplicationStatus.valueOf((String)"RESOLVING");
        result = (ApplicationStatus)trigger.execute((Object)snaMethodResult);
        Assertions.assertTrue((boolean)snaMethodResult.hasError());
        Assertions.assertTrue((boolean)result.equals((Object)ApplicationStatus.valueOf((String)"RESOLVING")));
    }
}

