/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import org.eclipse.sensinact.gateway.app.api.exception.LifeCycleException;
import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.trigger.AbstractAccessMethodTrigger;

public class AppLifecycleTrigger
extends AbstractAccessMethodTrigger {
    private static final String APP_LIFECYCLE_TRIGGER = "AppLifecycleTrigger";
    private final ApplicationService service;

    public AppLifecycleTrigger(ApplicationService service) {
        super(null, "INTERMEDIATE", true);
        this.service = service;
    }

    public String getName() {
        return APP_LIFECYCLE_TRIGGER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(Object object) throws Exception {
        AccessMethodResponseBuilder snaResult = (AccessMethodResponseBuilder)object;
        String uri = snaResult.getPath();
        ApplicationStatus currentStatus = (ApplicationStatus)((Object)this.service.getResource("status").getAttribute("value").getValue());
        if (uri.endsWith("START")) {
            if (snaResult.hasError()) return ApplicationStatus.UNRESOLVED;
            if (ApplicationStatus.INSTALLED.equals((Object)currentStatus)) return ApplicationStatus.RESOLVING;
            if (ApplicationStatus.UNRESOLVED.equals((Object)currentStatus)) {
                return ApplicationStatus.RESOLVING;
            }
            if (!currentStatus.equals((Object)ApplicationStatus.RESOLVING)) return currentStatus;
            return ApplicationStatus.ACTIVE;
        }
        if (uri.endsWith("UNINSTALL")) {
            if (ApplicationStatus.INSTALLED.equals((Object)currentStatus)) return ApplicationStatus.UNINSTALLED;
            if (ApplicationStatus.UNRESOLVED.equals((Object)currentStatus)) {
                return ApplicationStatus.UNINSTALLED;
            }
            snaResult.registerException((Exception)new LifeCycleException("Unable to UNINSTALL an application which is not in an INSTALLED or UNRESOLVED state"));
            return currentStatus;
        } else if (uri.endsWith("STOP")) {
            if (ApplicationStatus.ACTIVE.equals((Object)currentStatus)) {
                return ApplicationStatus.INSTALLED;
            }
            snaResult.registerException((Exception)new LifeCycleException("Unable to STOP an application which is not in an ACTIVE state"));
            return currentStatus;
        } else {
            if (!uri.endsWith("EXCEPTION")) return currentStatus;
            if (ApplicationStatus.ACTIVE.equals((Object)currentStatus)) {
                return ApplicationStatus.UNRESOLVED;
            }
            snaResult.registerException((Exception)new LifeCycleException("This should never happened"));
        }
        return currentStatus;
    }

    public String doGetJSON() {
        return null;
    }
}

