/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.test;

import java.util.ArrayList;
import org.eclipse.sensinact.gateway.app.api.function.FunctionUpdateListener;
import org.eclipse.sensinact.gateway.app.basic.logic.BetweenFunction;
import org.eclipse.sensinact.gateway.app.basic.logic.DoubleConditionFunction;
import org.eclipse.sensinact.gateway.app.basic.logic.SimpleConditionFunction;
import org.eclipse.sensinact.gateway.app.manager.component.data.ConstantData;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestLogicFunction {
    private ClassLoader cl = (ClassLoader)Mockito.mock(ClassLoader.class);
    private FunctionUpdateListener listener = (FunctionUpdateListener)Mockito.mock(FunctionUpdateListener.class);

    @BeforeEach
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    public void testIntegerSimpleConditionEquals() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "equal");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)10, Integer.class));
        variables.add(new ConstantData((Object)10, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testStringSimpleConditionEquals() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "equal");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)"sNa test", String.class));
        variables.add(new ConstantData((Object)"sNa test", String.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testBooleanSimpleConditionEquals() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "equal");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)false, Boolean.class));
        variables.add(new ConstantData((Object)false, Boolean.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testFloatSimpleConditionEquals() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "equal");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)Float.valueOf(1.0f), Float.class));
        variables.add(new ConstantData((Object)Float.valueOf(1.0f), Float.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testIntegerSimpleConditionGreater() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "greaterThan");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)2, Integer.class));
        variables.add(new ConstantData((Object)1, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testIntegerSimpleConditionGreaterOrEquals() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "greaterEqual");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)2, Integer.class));
        variables.add(new ConstantData((Object)2, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testIntegerSimpleConditionLesser() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "lesserThan");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)1, Integer.class));
        variables.add(new ConstantData((Object)2, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testIntegerSimpleConditionLesserOrEquals() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "lesserEqual");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)2, Integer.class));
        variables.add(new ConstantData((Object)2, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testRegexSimpleCondition() {
        SimpleConditionFunction function = new SimpleConditionFunction(this.cl, "regex");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)"Hello", String.class));
        variables.add(new ConstantData((Object)"([A-Z])\\w+", String.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testCorrectDoubleConditionAnd() {
        DoubleConditionFunction function = new DoubleConditionFunction("and");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)true, Boolean.class));
        variables.add(new ConstantData((Object)true, Boolean.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testWringDoubleConditionAnd() {
        DoubleConditionFunction function = new DoubleConditionFunction("and");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)false, Boolean.class));
        variables.add(new ConstantData((Object)true, Boolean.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)false);
    }

    public void testCorrectDoubleConditionOr() {
        DoubleConditionFunction function = new DoubleConditionFunction("or");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)true, Boolean.class));
        variables.add(new ConstantData((Object)false, Boolean.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testWringDoubleConditionOr() {
        DoubleConditionFunction function = new DoubleConditionFunction("or");
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)false, Boolean.class));
        variables.add(new ConstantData((Object)false, Boolean.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)false);
    }

    public void testCorrectDoubleConditionBetween() {
        BetweenFunction function = new BetweenFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)20, Integer.class));
        variables.add(new ConstantData((Object)0, Integer.class));
        variables.add(new ConstantData((Object)100, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)true);
    }

    public void testWrongDoubleConditionBetween() {
        BetweenFunction function = new BetweenFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)200, Integer.class));
        variables.add(new ConstantData((Object)0, Integer.class));
        variables.add(new ConstantData((Object)100, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)false);
    }
}

