/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ModelAlreadyRegisteredException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.ModelInstanceBuilder;
import org.eclipse.sensinact.gateway.generic.Connector;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelInstance;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtModelInstanceBuilder<P extends Packet, C extends ExtModelConfiguration<P>, I extends ExtModelInstance<C>>
extends ModelInstanceBuilder<C, I> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtModelInstanceBuilder.class);
    private Connector<? extends Packet> connector;

    public ExtModelInstanceBuilder(Mediator mediator) {
        super(mediator);
    }

    protected ExtModelInstanceBuilder<P, C, I> withConnector(Connector<P> connector) {
        this.connector = connector;
        return this;
    }

    public I build(String name, String profileId, C modelConfiguration) {
        ExtModelInstance instance = null;
        if (modelConfiguration != null) {
            super.buildAccessNode(modelConfiguration.getAccessTree(), name);
            Class ci = modelConfiguration.getModelInstanceType();
            instance = ci != null ? (ExtModelInstance)((Object)ReflectUtils.getInstance(ExtModelInstance.class, (Class)ci, (Object[])new Object[]{this.mediator, modelConfiguration, name, profileId, this.connector})) : (ExtModelInstance)((Object)ReflectUtils.getInstance(ExtModelInstance.class, (Object[])new Object[]{this.mediator, modelConfiguration, name, profileId, this.connector}));
            try {
                super.register((ModelInstance)instance);
            }
            catch (ModelAlreadyRegisteredException e) {
                LOG.error("Model instance '%s' already exists", (Object)name);
                instance = null;
            }
        }
        return (I)((Object)instance);
    }
}

