/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.oauth2.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.oauth2.OpenIDServer;
import org.eclipse.sensinact.gateway.security.oauth2.filter.SecurityFilter;
import org.eclipse.sensinact.gateway.security.oauth2.servlet.SecurityServlet;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    public static final String AUTH_SECURITY_CONFIG = "org.eclipse.sensinact.security.oauth2.config";

    public void doStart() throws Exception {
        String configfile = (String)this.mediator.getProperty(AUTH_SECURITY_CONFIG);
        OpenIDServer oidcServer = new OpenIDServer(this.mediator.getContext(), configfile);
        this.mediator.register((Object)new SecurityFilter(oidcServer, oidcServer), Filter.class, (Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("service.ranking", 0);
                this.put("osgi.http.whiteboard.filter.pattern", "/sensinact/*");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            }
        });
        this.mediator.register((Object)new SecurityServlet(oidcServer, oidcServer), Servlet.class, (Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("osgi.http.whiteboard.servlet.pattern", "/sensinact.auth");
                this.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
            }
        });
    }

    public void doStop() throws Exception {
    }

    public Mediator doInstantiate(BundleContext context) {
        Mediator mediator = new Mediator(context);
        return mediator;
    }
}

