/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.tree.test;

import org.eclipse.sensinact.gateway.util.tree.PathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNodeFactory;
import org.eclipse.sensinact.gateway.util.tree.PathTree;
import org.junit.jupiter.api.Test;

public class PathTreeTest {
    @Test
    public <P extends PathNode<P>> void testTree() {
        MyTree tree = new MyTree();
        tree.add("/aaaaaaa");
        tree.add("/vvvvvvv");
        tree.add("/ccccccc");
        tree.add("/uuuuuuu");
        tree.add("/hhhhhhh");
        tree.add("/test/service/resource");
        tree.add("/test/", ".*", true);
        tree.add("/test/.*/location");
        System.out.println(tree.toString());
        PathNode node = tree.get("/test/myservice/location");
        System.out.println(node.getPath());
        tree.delete("/test/service");
        System.out.println(tree.toString());
        tree.delete("/xxxxx");
        System.out.println(tree.toString());
    }

    class MyTree<P extends PathNode<P>>
    extends PathTree<P> {
        MyTree() {
            super(new PathNodeFactory<P>(){

                public P createPathNode(String nodeName) {
                    return new PathNode(nodeName);
                }

                public P createPatternNode(String nodeName) {
                    return new PathNode(nodeName, true);
                }

                public P createRootNode() {
                    return new PathNode();
                }
            });
        }
    }
}

