/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.util.json.JSONStatement;
import org.eclipse.sensinact.gateway.util.json.JSONTokenerStatement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONArrayStatement
extends JSONArray
implements JSONStatement {
    private Map<String, JSONStatement.JSONVariable> variables = new HashMap<String, JSONStatement.JSONVariable>();

    public JSONArrayStatement(String json) throws JSONException {
        this(new JSONTokenerStatement(json));
    }

    public JSONArrayStatement(JSONTokenerStatement tokener) throws JSONException {
        if (tokener.nextClean() != '[') {
            throw tokener.syntaxError("A JSONArray text must start with '['");
        }
        if (tokener.nextClean() != ']') {
            tokener.back();
            block4: while (true) {
                if (tokener.nextClean() == ',') {
                    tokener.back();
                    this.put(JSONObject.NULL);
                } else {
                    tokener.back();
                    this.put(tokener.nextValue());
                }
                switch (tokener.nextClean()) {
                    case ',': {
                        if (tokener.nextClean() == ']') {
                            return;
                        }
                        tokener.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or ']'");
        }
    }

    @Override
    public JSONArray put(Object value) throws JSONException {
        super.put(value);
        if (value != null && JSONStatement.JSONVariable.class.isAssignableFrom(value.getClass())) {
            JSONStatement.JSONVariable jsonVariable = (JSONStatement.JSONVariable)value;
            this.variables.put(jsonVariable.getName(), jsonVariable);
        }
        return this;
    }

    @Override
    public Object remove(int index) {
        Object value = super.remove(index);
        if (value != null && JSONStatement.JSONVariable.class.isAssignableFrom(value.getClass())) {
            JSONStatement.JSONVariable jsonVariable = (JSONStatement.JSONVariable)value;
            this.variables.remove(jsonVariable.getName());
        }
        return value;
    }

    @Override
    public boolean apply(String variable, Object value) {
        JSONStatement.JSONVariable jsonVariable = this.variables.get(variable);
        if (jsonVariable != null) {
            jsonVariable.setValue(value);
            return true;
        }
        int length = super.length();
        for (int index = 0; index < length; ++index) {
            Object object = super.get(index);
            if (!JSONStatement.class.isAssignableFrom(object.getClass()) || !((JSONStatement)object).apply(variable, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        Iterator<JSONStatement.JSONVariable> variableIterator = this.variables.values().iterator();
        while (variableIterator.hasNext()) {
            variableIterator.next().reset();
        }
        int length = super.length();
        for (int index = 0; index < length; ++index) {
            Object object = super.get(index);
            if (!JSONStatement.class.isAssignableFrom(object.getClass())) continue;
            ((JSONStatement)object).reset();
        }
    }
}

