/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNodeList;
import org.eclipse.sensinact.gateway.util.tree.PathNodeList;

public class ImmutablePathNode<P extends ImmutablePathNode<P>>
implements Iterable<P> {
    protected final P parent;
    protected final String nodeName;
    protected final ImmutablePathNodeList<P> children;
    protected final Pattern pattern;
    protected final boolean isRoot;
    protected final boolean isPattern;

    public ImmutablePathNode(PathNodeList<?> children) {
        this("/", children);
    }

    public ImmutablePathNode(String nodeName, PathNodeList<?> children) {
        this(null, nodeName, false, children);
    }

    public ImmutablePathNode(P parent, String nodeName, boolean isPattern, PathNodeList<?> children) {
        this.parent = parent;
        this.nodeName = nodeName;
        this.isRoot = nodeName.intern() == "/";
        this.isPattern = isPattern;
        this.pattern = isPattern ? Pattern.compile(nodeName) : null;
        this.children = children != null ? children.immutable(this) : new ImmutablePathNodeList(Collections.emptyList());
    }

    public P get(String path) {
        return this.get(UriUtils.getUriElements(path), 0);
    }

    public P get(String[] path, int index) {
        ImmutablePathNode<P> node = null;
        if (this.isRoot && index != 0 || !this.isRoot && (path.length - index < 1 || !this.equals(path[index]))) {
            return (P)node;
        }
        int inc = this.isRoot ? 0 : 1;
        node = this;
        ImmutablePathNode child = null;
        if (path.length - index > inc) {
            P p = this.children.get(path[index + inc]);
            child = (ImmutablePathNode)p;
            if (p != null) {
                node = child.get(path, index + inc);
            }
        }
        return (P)node;
    }

    public int hashCode() {
        return this.nodeName.hashCode();
    }

    public String getName() {
        return this.nodeName;
    }

    public String getPath() {
        if (this.parent == null) {
            return "";
        }
        return UriUtils.getUri(new String[]{((ImmutablePathNode)this.parent).getPath(), this.nodeName});
    }

    public boolean equals(Object object) {
        String objectName = null;
        if (ImmutablePathNode.class.isAssignableFrom(object.getClass())) {
            objectName = ((ImmutablePathNode)object).nodeName;
        } else if (String.class == object.getClass()) {
            objectName = (String)object;
        }
        if (objectName == null) {
            return false;
        }
        return !this.isPattern ? this.nodeName.equals(objectName) : this.pattern.matcher(objectName).matches();
    }

    public int size() {
        return this.children.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.nodeName);
        builder.append("[");
        for (ImmutablePathNode node : this.children) {
            builder.append(node.toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Iterator<P> iterator() {
        return this.children.iterator();
    }
}

